/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.scons;

import com.thalesgroup.hudson.plugins.scons.SConsInstallation;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SConsBuilder
extends Builder {
    private final String sconsName;
    private final String options;
    private final String variables;
    private final String targets;
    private final String rootSconsscriptDirectory;
    private final String sconsscript;
    public static final SConsBuilderDescriptor DESCRIPTOR = new SConsBuilderDescriptor();

    @DataBoundConstructor
    public SConsBuilder(String sconsName, String options, String variables, String targets, String rootSconsscriptDirectory, String sconsscript) {
        this.sconsName = sconsName;
        this.options = options;
        this.variables = variables;
        this.targets = targets;
        this.rootSconsscriptDirectory = rootSconsscriptDirectory;
        this.sconsscript = sconsscript;
    }

    public String getSconsName() {
        return this.sconsName;
    }

    public String getOptions() {
        return this.options;
    }

    public String getVariables() {
        return this.variables;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getRootSconsscriptDirectory() {
        return this.rootSconsscriptDirectory;
    }

    public String getSconsscript() {
        return this.sconsscript;
    }

    public SConsInstallation getScons() {
        for (SConsInstallation i : DESCRIPTOR.getInstallations()) {
            if (this.sconsName == null || !i.getName().equals(this.sconsName)) continue;
            return i;
        }
        return null;
    }

    public boolean perform(Build<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        Project proj = (Project)build.getProject();
        ArgumentListBuilder args = new ArgumentListBuilder();
        String execName = launcher.isUnix() ? "scons" : "scons";
        SConsInstallation ai = this.getScons();
        if (ai == null) {
            args.add(execName);
        } else {
            File exec = ai.getExecutable();
            if (!ai.getExists()) {
                listener.fatalError(exec + " doesn't exist");
                return false;
            }
            args.add(exec.getPath());
        }
        String normalizedOptions = this.options.replaceAll("[\t\r\n]+", " ");
        String normalizedSconsscript = this.sconsscript.replaceAll("[\t\r\n]+", " ");
        String normalizedRootSconsscriptDirectory = this.rootSconsscriptDirectory.replaceAll("[\t\r\n]+", " ");
        String normalizedFileVariables = this.variables.replaceAll("[\t\r\n]+", " ");
        String normalizedTargets = this.targets.replaceAll("[\t\r\n]+", " ");
        if (normalizedOptions != null && normalizedOptions.trim().length() != 0) {
            args.addTokenized(normalizedOptions);
        }
        if (normalizedSconsscript != null && normalizedSconsscript.trim().length() != 0) {
            normalizedSconsscript = Util.replaceMacro((String)normalizedSconsscript, (Map)build.getEnvVars());
            args.add("-f");
            args.add(normalizedSconsscript);
        }
        if (normalizedRootSconsscriptDirectory != null && normalizedRootSconsscriptDirectory.trim().length() != 0) {
            normalizedRootSconsscriptDirectory = Util.replaceMacro((String)normalizedRootSconsscriptDirectory, (Map)build.getEnvVars());
            args.add("-C");
            args.add(normalizedRootSconsscriptDirectory);
        }
        if (normalizedFileVariables != null && normalizedFileVariables.trim().length() != 0) {
            args.addTokenized(normalizedFileVariables);
        }
        if (normalizedTargets != null && normalizedTargets.trim().length() != 0) {
            args.addTokenized(normalizedTargets);
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch(args.toCommandArray(), build.getEnvVars(), (OutputStream)listener.getLogger(), proj.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SConsBuilderDescriptor
    extends Descriptor<Builder> {
        private volatile SConsInstallation[] installations = new SConsInstallation[0];

        private SConsBuilderDescriptor() {
            super(SConsBuilder.class);
            this.load();
        }

        public String getHelpFile() {
            return "/plugin/scons/SConsBuilder/help.html";
        }

        public String getDisplayName() {
            return "Invoke scons script";
        }

        public SConsInstallation[] getInstallations() {
            return this.installations;
        }

        public boolean configure(StaplerRequest req) {
            this.installations = req.bindParametersToList(SConsInstallation.class, "scons.").toArray(new SConsInstallation[0]);
            this.save();
            return true;
        }
    }
}

