/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.scons;

import com.thalesgroup.hudson.plugins.scons.Messages;
import com.thalesgroup.hudson.plugins.scons.SConsAbstractBuilder;
import com.thalesgroup.hudson.plugins.scons.SConsBuilderDescriptor;
import com.thalesgroup.hudson.plugins.scons.SConsInstallation;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SConsBuilderScriptFile
extends SConsAbstractBuilder {
    private final String sconsscript;
    @Extension
    public static final SConsBuilderScriptFileDescriptor DESCRIPTOR = new SConsBuilderScriptFileDescriptor();

    @DataBoundConstructor
    public SConsBuilderScriptFile(String sconsName, String options, String variables, String targets, String rootSconsscriptDirectory, String sconsscript) {
        super(sconsName, options, variables, targets, rootSconsscriptDirectory);
        this.sconsscript = sconsscript;
    }

    @Override
    public SConsInstallation getSconsInstallation() {
        for (SConsInstallation installation : DESCRIPTOR.getInstallations()) {
            if (this.getSconsName() == null || !installation.getName().equals(this.getSconsName())) continue;
            return installation;
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (this.buildSconsExecutable(launcher, listener, args, env)) {
            return false;
        }
        String normalizedOptions = this.getOptions().replaceAll("[\t\r\n]+", " ");
        String normalizedFileVariables = this.getVariables().replaceAll("[\t\r\n]+", " ");
        String normalizedTargets = this.getTargets().replaceAll("[\t\r\n]+", " ");
        if (normalizedOptions != null && normalizedOptions.trim().length() != 0) {
            args.addTokenized(normalizedOptions);
        }
        String normalizedRootSconsscriptDirectory = this.getRootSconsscriptDirectory().replaceAll("[\t\r\n]+", " ");
        String normalizedSconsscript = this.getSconsscript().replaceAll("[\t\r\n]+", " ");
        if (normalizedSconsscript != null && normalizedSconsscript.trim().length() != 0) {
            normalizedSconsscript = Util.replaceMacro((String)normalizedSconsscript, (Map)build.getEnvironment((TaskListener)listener));
            args.add("-f");
            args.add(normalizedSconsscript);
        }
        if (normalizedRootSconsscriptDirectory != null && normalizedRootSconsscriptDirectory.trim().length() != 0) {
            normalizedRootSconsscriptDirectory = Util.replaceMacro((String)normalizedRootSconsscriptDirectory, (Map)build.getEnvironment((TaskListener)listener));
            args.add("-C");
            args.add(normalizedRootSconsscriptDirectory);
        }
        if (normalizedFileVariables != null && normalizedFileVariables.trim().length() != 0) {
            args.addTokenized(normalizedFileVariables);
        }
        if (normalizedTargets != null && normalizedTargets.trim().length() != 0) {
            args.addTokenized(normalizedTargets);
        }
        if (!launcher.isUnix()) {
            args.prepend(new String[]{"cmd.exe", "/C"});
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
        }
        try {
            int r = launcher.launch().cmds(args).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            return false;
        }
    }

    @Override
    public SConsBuilderDescriptor getDescritor() {
        return DESCRIPTOR;
    }

    public String getSconsscript() {
        return this.sconsscript;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SConsBuilderScriptFileDescriptor
    extends SConsBuilderDescriptor {
        public SConsBuilderScriptFileDescriptor() {
            this.load();
        }

        protected SConsBuilderScriptFileDescriptor(Class<? extends SConsBuilderScriptFile> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return Messages.scons_scriptFile_displayName();
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(SConsBuilderScriptFile.class, formData);
        }
    }
}

