/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.scons;

import com.thalesgroup.hudson.plugins.scons.Messages;
import com.thalesgroup.hudson.plugins.scons.SConsBuilderDescriptor;
import com.thalesgroup.hudson.plugins.scons.SConsInstallation;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;

public abstract class SConsAbstractBuilder
extends Builder {
    private final String sconsName;
    private final String options;
    private final String variables;
    private final String targets;
    private final String rootSconsscriptDirectory;

    protected SConsAbstractBuilder(String sconsName, String options, String variables, String targets, String rootSconsscriptDirectory) {
        this.sconsName = sconsName;
        this.options = options;
        this.variables = variables;
        this.targets = targets;
        this.rootSconsscriptDirectory = rootSconsscriptDirectory;
    }

    public String getSconsName() {
        return this.sconsName;
    }

    public String getOptions() {
        return this.options;
    }

    public String getVariables() {
        return this.variables;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getRootSconsscriptDirectory() {
        return this.rootSconsscriptDirectory;
    }

    protected boolean buildSconsExecutable(Launcher launcher, BuildListener listener, ArgumentListBuilder args, EnvVars env) throws IOException, InterruptedException {
        SConsInstallation sconsInstallation = this.getSconsInstallation();
        if (sconsInstallation == null) {
            args.add("scons");
        } else {
            sconsInstallation = sconsInstallation.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            String sconsExecutable = (sconsInstallation = sconsInstallation.forEnvironment(env)).getSconsExecutable(launcher);
            if (sconsExecutable == null) {
                listener.fatalError(Messages.scons_NoSconsExecutable());
                return true;
            }
            args.add(sconsExecutable);
        }
        return false;
    }

    protected SConsInstallation getSconsInstallation() {
        for (SConsInstallation installation : this.getDescritor().getInstallations()) {
            if (this.getSconsName() == null || !installation.getName().equals(this.getSconsName())) continue;
            return installation;
        }
        return null;
    }

    public abstract SConsBuilderDescriptor getDescritor();
}

