/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.scons;

import com.thalesgroup.hudson.plugins.scons.Messages;
import com.thalesgroup.hudson.plugins.scons.SConsBuilderScriptFile;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SConsInstallation
extends ToolInstallation
implements NodeSpecific<SConsInstallation>,
EnvironmentSpecific<SConsInstallation> {
    @DataBoundConstructor
    public SConsInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public SConsInstallation forEnvironment(EnvVars environment) {
        return new SConsInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public SConsInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new SConsInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public String getSconsExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

            public String call() throws IOException {
                File execFileName = new File(Util.replaceMacro((String)SConsInstallation.this.getHome(), (Map)EnvVars.masterEnvVars));
                if (execFileName.exists()) {
                    return execFileName.getPath();
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<SConsInstallation> {
        private volatile SConsInstallation[] installations = new SConsInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(SConsBuilderScriptFile.class).format("DisplayName", new Object[0]);
        }

        public SConsInstallation[] getInstallations() {
            return (SConsInstallation[])this.installations.clone();
        }

        public void setInstallations(SConsInstallation[] installs) {
            this.installations = installs;
            this.save();
        }

        public FormValidation doCheckHome(@QueryParameter File value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value.getPath().equals("")) {
                return FormValidation.error((String)Messages.scons_InstallationFolderMustBeSet());
            }
            if (!value.isFile()) {
                return FormValidation.error((String)Messages.scons_NotAFile());
            }
            return FormValidation.ok();
        }
    }
}

