/*
 * Decompiled with CFR 0.152.
 */
package be.certipost.hudson.plugin;

import be.certipost.hudson.plugin.Entry;
import be.certipost.hudson.plugin.SCPRepositoryPublisher;
import be.certipost.hudson.plugin.SCPSite;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCPRepositoryPublisher
extends Publisher {
    private String siteName;
    private final List<Entry> entries = new ArrayList();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SCPRepositoryPublisher() {
    }

    public SCPRepositoryPublisher(String siteName) {
        SCPSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public SCPSite getSite() {
        SCPSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (SCPSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws InterruptedException {
        if (build.getResult() == Result.FAILURE) {
            return true;
        }
        SCPSite scpsite = null;
        try {
            scpsite = this.getSite();
            listener.getLogger().println("Connecting to " + scpsite.getHostname());
            scpsite.createSession();
            Map envVars = build.getEnvVars();
            for (Entry e : this.entries) {
                String expanded = Util.replaceMacro((String)e.sourceFile, (Map)envVars);
                FilePath[] src = build.getProject().getWorkspace().list(expanded);
                String folderPath = Util.replaceMacro((String)e.filePath, (Map)envVars);
                if (src.length == 0) {
                    listener.getLogger().println("No file(s) found: " + expanded);
                }
                if (src.length == 1) {
                    listener.getLogger().println("remote folderPath " + folderPath + ",local file:" + src[0].getName());
                    scpsite.upload(folderPath, src[0], envVars, listener.getLogger());
                    continue;
                }
                for (FilePath s : src) {
                    listener.getLogger().println("remote folderPath " + folderPath + ",local file:" + s.getName());
                    scpsite.upload(folderPath, s, envVars, listener.getLogger());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        catch (JSchException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        catch (SftpException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        finally {
            if (scpsite != null) {
                scpsite.closeSession();
            }
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }
}

