/*
 * Decompiled with CFR 0.152.
 */
package be.certipost.hudson.plugin;

import be.certipost.hudson.plugin.SCPUserInfo;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCPSite {
    String hostname;
    int port;
    String username;
    String password;
    String rootRepositoryPath;
    JSch jsch;
    private Session session;
    private ChannelSftp channel;

    public SCPSite() {
    }

    public SCPSite(String hostname, int port, String username, String password, String rootRepositoryPath) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.rootRepositoryPath = rootRepositoryPath;
    }

    public SCPSite(String hostname, String port, String username, String password) {
        this.hostname = hostname;
        try {
            this.port = Integer.parseInt(port);
        }
        catch (Exception e) {
            this.port = 22;
        }
        this.username = username;
        this.password = password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return "" + this.port;
    }

    public void setPort(String port) {
        try {
            this.port = Integer.parseInt(port);
        }
        catch (Exception e) {
            this.port = 22;
        }
    }

    public int getIntegerPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRootRepositoryPath() {
        return this.rootRepositoryPath;
    }

    public void setRootRepositoryPath(String rootRepositoryPath) {
        this.rootRepositoryPath = rootRepositoryPath;
    }

    public String getName() {
        return this.hostname;
    }

    public void createSession() throws JSchException {
        this.jsch = new JSch();
        this.session = this.jsch.getSession(this.username, this.hostname, this.port);
        this.session.setPassword(this.password);
        SCPUserInfo ui = new SCPUserInfo(this.password);
        this.session.setUserInfo((UserInfo)ui);
        this.session.connect();
        this.channel = (ChannelSftp)this.session.openChannel("sftp");
        this.channel.connect();
    }

    public void closeSession() {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public void upload(String folderPath, FilePath filePath, Map<String, String> envVars, PrintStream logger) throws IOException, InterruptedException, SftpException {
        if (this.session == null || this.channel == null) {
            throw new IOException("Connection to " + this.hostname + ", user=" + this.username + " is not established");
        }
        SftpATTRS rootdirstat = this.channel.stat(this.rootRepositoryPath);
        if (rootdirstat == null) {
            throw new IOException("Can't get stat of root repository directory:" + this.rootRepositoryPath);
        }
        if (!rootdirstat.isDir()) {
            throw new IOException(this.rootRepositoryPath + " is not a directory");
        }
        if (filePath.isDirectory()) {
            FilePath[] subfiles = filePath.list("**/*");
            if (subfiles != null) {
                for (int i = 0; i < subfiles.length; ++i) {
                    this.upload(folderPath + "/" + filePath.getName(), subfiles[i], envVars, logger);
                }
            }
        } else {
            String localfilename = filePath.getName();
            this.mkdirs(folderPath, logger);
            InputStream in = filePath.read();
            this.channel.put(in, this.rootRepositoryPath + "/" + folderPath + "/" + localfilename);
            in.close();
        }
    }

    private void mkdirs(String filePath, PrintStream logger) throws SftpException, IOException {
        String[] pathnames = filePath.split("/");
        String curdir = this.rootRepositoryPath;
        if (pathnames != null) {
            for (int i = 0; i < pathnames.length; ++i) {
                SftpATTRS dirstat;
                block7: {
                    if (pathnames[i].length() == 0) continue;
                    dirstat = null;
                    try {
                        dirstat = this.channel.stat(curdir + "/" + pathnames[i]);
                    }
                    catch (SftpException e) {
                        if (e.getMessage() == null || e.getMessage().indexOf("No such file") != -1) break block7;
                        logger.println("Error getting stat of  directory:" + curdir + "/" + pathnames[i] + ":" + e.getMessage());
                        throw e;
                    }
                }
                if (dirstat == null) {
                    logger.println("Trying to create " + curdir + "/" + pathnames[i]);
                    this.channel.mkdir(curdir + "/" + pathnames[i]);
                } else if (!dirstat.isDir()) {
                    throw new IOException(curdir + "/" + pathnames[i] + " is not a directory:" + dirstat);
                }
                curdir = curdir + "/" + pathnames[i];
            }
        }
    }
}

