/*
 * Decompiled with CFR 0.152.
 */
package be.certipost.hudson.plugin;

import be.certipost.hudson.plugin.Entry;
import be.certipost.hudson.plugin.SCPSite;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.Publisher;
import hudson.util.CopyOnWriteList;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCPRepositoryPublisher
extends Publisher {
    private String siteName;
    public static final Logger LOGGER = Logger.getLogger(SCPRepositoryPublisher.class.getName());
    private final List<Entry> entries = new ArrayList<Entry>();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SCPRepositoryPublisher() {
    }

    public SCPRepositoryPublisher(String siteName) {
        SCPSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public SCPSite getSite() {
        SCPSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (SCPSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE) {
            return true;
        }
        SCPSite scpsite = null;
        try {
            scpsite = this.getSite();
            if (scpsite == null) {
                this.log(listener.getLogger(), "No SCP site is configured. This is likely a configuration problem.");
                build.setResult(Result.UNSTABLE);
                boolean bl = true;
                return bl;
            }
            this.log(listener.getLogger(), "Connecting to " + scpsite.getHostname());
            scpsite.createSession();
            Map envVars = build.getEnvVars();
            for (Entry e : this.entries) {
                String expanded = Util.replaceMacro((String)e.sourceFile, (Map)envVars);
                FilePath ws = build.getProject().getWorkspace();
                FilePath[] src = ws.list(expanded);
                if (src.length == 0) {
                    this.log(listener.getLogger(), "No file(s) found: " + expanded);
                    String error = ws.validateAntFileMask(expanded);
                    if (error != null) {
                        this.log(listener.getLogger(), error);
                    }
                }
                String folderPath = Util.replaceMacro((String)e.filePath, (Map)envVars);
                if (src.length == 1) {
                    this.log(listener.getLogger(), "remote folderPath " + folderPath + ",local file:" + src[0].getName());
                    scpsite.upload(folderPath, src[0], envVars, listener.getLogger());
                    continue;
                }
                for (FilePath s : src) {
                    this.log(listener.getLogger(), "remote folderPath " + folderPath + ",local file:" + s.getName());
                    scpsite.upload(folderPath, s, envVars, listener.getLogger());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        catch (JSchException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        catch (SftpException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        finally {
            if (scpsite != null) {
                scpsite.closeSession();
            }
        }
        return true;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Publisher> {
        private final CopyOnWriteList<SCPSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(SCPRepositoryPublisher.class);
            this.load();
        }

        protected DescriptorImpl(Class<? extends Publisher> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return "Publish artifacts to SCP Repository";
        }

        public String getShortName() {
            return "[SCP] ";
        }

        public String getHelpFile() {
            return "/plugin/scp/help.html";
        }

        public Publisher newInstance(StaplerRequest req) {
            SCPRepositoryPublisher pub = new SCPRepositoryPublisher();
            req.bindParameters((Object)pub, "scp.");
            pub.getEntries().addAll(req.bindParametersToList(Entry.class, "scp.entry."));
            return pub;
        }

        public SCPSite[] getSites() {
            Iterator it = this.sites.iterator();
            int size = 0;
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return (SCPSite[])this.sites.toArray((Object[])new SCPSite[size]);
        }

        public boolean configure(StaplerRequest req) {
            this.sites.replaceBy((Collection)req.bindParametersToList(SCPSite.class, "scp."));
            this.save();
            return true;
        }

        public void doKeyfileCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    File f;
                    String keyfile = Util.fixEmpty((String)this.request.getParameter("keyfile"));
                    if (keyfile != null && !(f = new File(keyfile)).isFile()) {
                        this.error("keyfile does not exits");
                    }
                }
            }.process();
        }

        public void doLoginCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, false){

                protected void check() throws IOException, ServletException {
                    String hostname = Util.fixEmpty((String)this.request.getParameter("hostname"));
                    if (hostname == null) {
                        this.ok();
                        return;
                    }
                    SCPSite site = new SCPSite(hostname, this.request.getParameter("port"), this.request.getParameter("user"), this.request.getParameter("pass"), this.request.getParameter("keyfile"));
                    try {
                        try {
                            site.createSession();
                            site.closeSession();
                        }
                        catch (JSchException e) {
                            LOGGER.log(Level.SEVERE, e.getMessage());
                            throw new IOException("Can't connect to server");
                        }
                        this.ok();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, e.getMessage());
                        this.error(e.getMessage());
                    }
                }
            }.process();
        }
    }
}

