/*
 * Decompiled with CFR 0.152.
 */
package be.certipost.hudson.plugin;

import be.certipost.hudson.plugin.Entry;
import be.certipost.hudson.plugin.SCPRepositoryPublisher;
import be.certipost.hudson.plugin.SCPSite;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SCPRepositoryPublisher
extends Notifier {
    private String siteName;
    public static final Logger LOGGER = Logger.getLogger(SCPRepositoryPublisher.class.getName());
    private final List<Entry> entries = new ArrayList();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SCPRepositoryPublisher() {
    }

    public SCPRepositoryPublisher(String siteName) {
        SCPSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public SCPSite getSite() {
        SCPSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (SCPSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE) {
            return true;
        }
        SCPSite scpsite = null;
        try {
            scpsite = this.getSite();
            if (scpsite == null) {
                this.log(listener.getLogger(), "No SCP site is configured. This is likely a configuration problem.");
                build.setResult(Result.UNSTABLE);
                boolean bl = true;
                return bl;
            }
            this.log(listener.getLogger(), "Connecting to " + scpsite.getHostname());
            scpsite.createSession();
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            for (Entry e : this.entries) {
                String expanded = Util.replaceMacro((String)e.sourceFile, (Map)envVars);
                FilePath ws = build.getWorkspace();
                FilePath[] src = ws.list(expanded);
                if (src.length == 0) {
                    this.log(listener.getLogger(), "No file(s) found: " + expanded);
                    String error = ws.validateAntFileMask(expanded);
                    if (error != null) {
                        this.log(listener.getLogger(), error);
                    }
                }
                String folderPath = Util.replaceMacro((String)e.filePath, (Map)envVars);
                if (src.length == 1) {
                    this.log(listener.getLogger(), "remote folderPath " + folderPath + ",local file:" + src[0].getName());
                    scpsite.upload(folderPath, src[0], (Map)envVars, listener.getLogger());
                    continue;
                }
                for (FilePath s : src) {
                    this.log(listener.getLogger(), "remote folderPath " + folderPath + ",local file:" + s.getName());
                    scpsite.upload(folderPath, s, (Map)envVars, listener.getLogger());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        catch (JSchException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        catch (SftpException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
        }
        finally {
            if (scpsite != null) {
                scpsite.closeSession();
            }
        }
        return true;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }
}

