/*
 * Decompiled with CFR 0.152.
 */
package be.certipost.hudson.plugin;

import be.certipost.hudson.plugin.Entry;
import be.certipost.hudson.plugin.SCPRepositoryPublisher;
import be.certipost.hudson.plugin.SCPSite;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public final class SCPRepositoryPublisher
extends Notifier {
    private String siteName;
    public static final Logger LOGGER = Logger.getLogger(SCPRepositoryPublisher.class.getName());
    private final List<Entry> entries = new ArrayList();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SCPRepositoryPublisher() {
    }

    public SCPRepositoryPublisher(String siteName) {
        SCPSite[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public SCPSite getSite() {
        SCPSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (SCPSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public static EnvVars getEnvVars() {
        DescribableList nodeProperties = SCPRepositoryPublisher.getNodeProperties();
        for (NodeProperty next : nodeProperties) {
            if (!(next instanceof EnvironmentVariablesNodeProperty)) continue;
            EnvironmentVariablesNodeProperty envVarProp = (EnvironmentVariablesNodeProperty)next;
            EnvVars envVars = envVarProp.getEnvVars();
            return envVars;
        }
        return null;
    }

    private static DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        Node node = Computer.currentComputer().getNode();
        DescribableList nodeProperties = node.getNodeProperties();
        if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            Hudson instance = Hudson.getInstance();
            nodeProperties = instance.getGlobalNodeProperties();
        }
        return nodeProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult() == Result.FAILURE) {
            return true;
        }
        SCPSite scpsite = null;
        PrintStream logger = listener.getLogger();
        Session session = null;
        ChannelSftp channel = null;
        try {
            scpsite = this.getSite();
            if (scpsite == null) {
                this.log(logger, "No SCP site is configured. This is likely a configuration problem.");
                build.setResult(Result.UNSTABLE);
                boolean bl = true;
                return bl;
            }
            this.log(logger, "Connecting to " + scpsite.getHostname());
            session = scpsite.createSession(logger);
            channel = scpsite.createChannel(logger, session);
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            EnvVars objNodeEnvVars = SCPRepositoryPublisher.getEnvVars();
            if (objNodeEnvVars != null) {
                envVars.putAll(objNodeEnvVars);
            }
            for (Entry e : this.entries) {
                String expanded = Util.replaceMacro((String)e.sourceFile, (Map)envVars);
                FilePath ws = build.getWorkspace();
                FilePath[] src = ws.list(expanded);
                if (src.length == 0) {
                    this.log(logger, "No file(s) found: " + expanded);
                    String error = ws.validateAntFileMask(expanded);
                    if (error == null) continue;
                    this.log(logger, error);
                    continue;
                }
                String folderPath = Util.replaceMacro((String)e.filePath, (Map)envVars);
                folderPath = folderPath.trim();
                String strWorkspacePath = ws.toString();
                String strFirstFile = src[0].toString();
                strWorkspacePath = strFirstFile.indexOf(92) >= 0 ? strWorkspacePath.replace('/', '\\') : strWorkspacePath.replace('\\', '/');
                envVars.put("strWorkspacePath", strWorkspacePath);
                if (src.length == 1) {
                    scpsite.upload(folderPath, src[0], (Map)envVars, logger, channel);
                    continue;
                }
                for (FilePath s : src) {
                    scpsite.upload(folderPath, s, (Map)envVars, logger, channel);
                }
            }
            if (scpsite == null) return true;
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
            return true;
        }
        catch (JSchException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
            return true;
        }
        catch (SftpException e) {
            e.printStackTrace(listener.error("Failed to upload files"));
            build.setResult(Result.UNSTABLE);
            return true;
        }
        finally {
            if (scpsite != null) {
                scpsite.closeSession(logger, session, channel);
            }
        }
        scpsite.closeSession(logger, session, channel);
        return true;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }
}

