/*
 * Decompiled with CFR 0.152.
 */
package be.certipost.hudson.plugin;

import be.certipost.hudson.plugin.SCPRepositoryPublisher;
import be.certipost.hudson.plugin.SCPUserInfo;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.DescribableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCPSite {
    String hostname;
    int port;
    String username;
    String password;
    String keyfile;
    String rootRepositoryPath;
    public static final Logger LOGGER = Logger.getLogger(SCPSite.class.getName());

    public SCPSite() {
    }

    public SCPSite(String hostname, int port, String username, String password, String rootRepositoryPath) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.rootRepositoryPath = rootRepositoryPath.trim();
    }

    public SCPSite(String hostname, String port, String username, String password) {
        this.hostname = hostname;
        try {
            this.port = Integer.parseInt(port);
        }
        catch (Exception e) {
            this.port = 22;
        }
        this.username = username;
        this.password = password;
    }

    public SCPSite(String hostname, String port, String username, String passphrase, String keyfile) {
        this(hostname, port, username, passphrase);
        this.keyfile = keyfile;
    }

    public String getKeyfile() {
        return this.keyfile;
    }

    public void setKeyfile(String keyfile) {
        this.keyfile = keyfile;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return "" + this.port;
    }

    public void setPort(String port) {
        try {
            this.port = Integer.parseInt(port);
        }
        catch (Exception e) {
            this.port = 22;
        }
    }

    public int getIntegerPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRootRepositoryPath() {
        return this.rootRepositoryPath;
    }

    public void setRootRepositoryPath(String rootRepositoryPath) {
        this.rootRepositoryPath = rootRepositoryPath.trim();
    }

    public String getName() {
        return this.hostname;
    }

    public Session createSession(PrintStream logger) throws JSchException {
        JSch jsch = new JSch();
        Session session = jsch.getSession(this.username, this.hostname, this.port);
        if (this.keyfile != null && this.keyfile.length() > 0) {
            jsch.addIdentity(this.keyfile, this.password);
        } else {
            session.setPassword(this.password);
        }
        SCPUserInfo ui = new SCPUserInfo(this.password);
        session.setUserInfo((UserInfo)ui);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        return session;
    }

    public ChannelSftp createChannel(PrintStream logger, Session session) throws JSchException {
        ChannelSftp channel = (ChannelSftp)session.openChannel("sftp");
        channel.setOutputStream((OutputStream)System.out);
        channel.connect();
        return channel;
    }

    public void closeSession(PrintStream logger, Session session, ChannelSftp channel) {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
        if (session != null) {
            session.disconnect();
            session = null;
        }
    }

    public void upload(String folderPath, FilePath filePath, boolean keepHierarchy, Map<String, String> envVars, PrintStream logger, ChannelSftp channel) throws IOException, InterruptedException, SftpException {
        if (channel == null) {
            throw new IOException("Connection to " + this.hostname + ", user=" + this.username + " is not established");
        }
        SftpATTRS rootdirstat = channel.stat(this.rootRepositoryPath);
        if (rootdirstat == null) {
            throw new IOException("Can't get stat of root repository directory:" + this.rootRepositoryPath);
        }
        if (!rootdirstat.isDir()) {
            throw new IOException(this.rootRepositoryPath + " is not a directory");
        }
        if (filePath.isDirectory()) {
            FilePath[] subfiles = filePath.list("**/*");
            if (subfiles != null) {
                for (int i = 0; i < subfiles.length; ++i) {
                    this.upload(folderPath + "/" + filePath.getName(), subfiles[i], keepHierarchy, envVars, logger, channel);
                }
            }
        } else {
            String strNewFilename;
            String localfilename = filePath.getName();
            this.mkdirs(folderPath, logger, channel);
            if (keepHierarchy) {
                String strWorkspacePath = envVars.get("strWorkspacePath");
                String strRelativePath = this.extractRelativePath(strWorkspacePath, filePath, logger);
                String strTmp = this.concatDir(folderPath, strRelativePath);
                String strNewPath = this.concatDir(this.rootRepositoryPath, strTmp);
                if (!strRelativePath.equals("")) {
                    this.mkdirs(strTmp, logger, channel);
                }
                if (!strNewPath.endsWith("/")) {
                    strNewPath = strNewPath + "/";
                }
                strNewFilename = strNewPath + localfilename;
            } else {
                String strTmp = this.concatDir(folderPath, localfilename);
                strNewFilename = this.concatDir(this.rootRepositoryPath, strTmp);
            }
            this.log(logger, "uploading file: '" + strNewFilename + "'");
            InputStream in = filePath.read();
            channel.put(in, strNewFilename);
            in.close();
        }
    }

    private void mkdirs(String filePath, PrintStream logger, ChannelSftp channel) throws SftpException, IOException {
        String[] pathnames = filePath.split("/");
        String curdir = this.rootRepositoryPath;
        if (pathnames != null) {
            for (int i = 0; i < pathnames.length; ++i) {
                SftpATTRS dirstat;
                block7: {
                    if (pathnames[i].length() == 0) continue;
                    dirstat = null;
                    try {
                        dirstat = channel.stat(curdir + "/" + pathnames[i]);
                    }
                    catch (SftpException e) {
                        if (e.getMessage() == null || e.getMessage().indexOf("No such file") != -1) break block7;
                        this.log(logger, "Error getting stat of  directory:" + curdir + "/" + pathnames[i] + ":" + e.getMessage());
                        throw e;
                    }
                }
                if (dirstat == null) {
                    this.log(logger, "Trying to create " + curdir + "/" + pathnames[i]);
                    channel.mkdir(curdir + "/" + pathnames[i]);
                } else if (!dirstat.isDir()) {
                    throw new IOException(curdir + "/" + pathnames[i] + " is not a directory:" + dirstat);
                }
                curdir = curdir + "/" + pathnames[i];
            }
        }
    }

    protected void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)SCPRepositoryPublisher.DESCRIPTOR.getShortName()) + message);
    }

    private String concatDir(String folderPath, String strRelativePath) {
        String strTmp = folderPath.endsWith("/") || folderPath.equals("") ? folderPath + strRelativePath : folderPath + "/" + strRelativePath;
        return strTmp;
    }

    private String extractRelativePath(String strWorkspacePath, FilePath filePath, PrintStream logger) {
        String strRet = "";
        String strFilePath = filePath.getParent().toString();
        if (strWorkspacePath.length() == strFilePath.length()) {
            return "";
        }
        if (strFilePath.length() > strWorkspacePath.length()) {
            strRet = strFilePath.substring(strWorkspacePath.length() + 1, strFilePath.length());
        }
        strRet = strRet.replace('\\', '/');
        return strRet;
    }

    private static DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        Node node = Computer.currentComputer().getNode();
        DescribableList nodeProperties = node.getNodeProperties();
        if (Computer.currentComputer() instanceof Hudson.MasterComputer) {
            Hudson instance = Hudson.getInstance();
            nodeProperties = instance.getGlobalNodeProperties();
        }
        return nodeProperties;
    }
}

