/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.screenshot;

import hudson.model.Action;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ScreenshotAction
implements Action {
    private VirtualChannel channel;

    public ScreenshotAction(VirtualChannel channel) {
        this.channel = channel;
    }

    public String getDisplayName() {
        return "Screenshot";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "screenshot";
    }

    public void doIndex(StaplerRequest request, StaplerResponse rsp) throws Exception {
        byte[] bytes = (byte[])this.channel.call((Callable)new CreateScreenshot());
        ServletOutputStream sos = rsp.getOutputStream();
        sos.write(bytes);
        sos.flush();
        sos.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateScreenshot
    implements Callable<byte[], Exception> {
        private static final long serialVersionUID = 1L;

        public byte[] call() throws HeadlessException, AWTException, IOException {
            Robot robot = new Robot();
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize().getSize();
            BufferedImage image = robot.createScreenCapture(new Rectangle(size));
            ByteArrayOutputStream os = new ByteArrayOutputStream((int)(size.getWidth() * size.getHeight() * 4.0));
            ImageIO.write((RenderedImage)image, "png", os);
            byte[] result = os.toByteArray();
            return result;
        }
    }
}

