/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.script_realm;

import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.QuotedStringTokenizer;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.io.output.NullOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class ScriptSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String commandLine;

    @DataBoundConstructor
    public ScriptSecurityRealm(String commandLine) {
        this.commandLine = commandLine;
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            StringWriter out = new StringWriter();
            Launcher.LocalLauncher launcher = new Launcher.LocalLauncher((TaskListener)new StreamTaskListener((Writer)out));
            if (launcher.launch().cmds(QuotedStringTokenizer.tokenize((String)this.commandLine)).stdout((OutputStream)new NullOutputStream()).envs(new String[]{"U=" + username, "P=" + password}).join() != 0) {
                throw new BadCredentialsException(out.toString());
            }
            return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
        }
        catch (InterruptedException e) {
            throw new AuthenticationServiceException("Interrupted", (Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationServiceException("Failed", (Throwable)e);
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException(groupname);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Authenticate via custom script";
        }
    }
}

