/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.script_realm;

import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.util.QuotedStringTokenizer;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class ScriptSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final Logger LOGGER = Logger.getLogger(ScriptSecurityRealm.class.getName());
    public final String commandLine;
    public final String groupsCommandLine;
    public final String groupsDelimiter;

    @DataBoundConstructor
    public ScriptSecurityRealm(String commandLine, String groupsCommandLine, String groupsDelimiter) {
        this.commandLine = commandLine;
        this.groupsCommandLine = groupsCommandLine;
        this.groupsDelimiter = StringUtils.isBlank((String)groupsDelimiter) ? "," : groupsDelimiter;
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            StringWriter out = new StringWriter();
            Launcher.LocalLauncher launcher = new Launcher.LocalLauncher((TaskListener)new StreamTaskListener((Writer)out));
            if (launcher.launch().cmds(QuotedStringTokenizer.tokenize((String)this.commandLine)).stdout((OutputStream)new NullOutputStream()).envs(new String[]{"U=" + username, "P=" + password}).join() != 0) {
                throw new BadCredentialsException(out.toString());
            }
            GrantedAuthority[] groups = this.loadGroups(username);
            return new User(username, "", true, true, true, true, groups);
        }
        catch (InterruptedException e) {
            throw new AuthenticationServiceException("Interrupted", (Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationServiceException("Failed", (Throwable)e);
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        GrantedAuthority[] groups = this.loadGroups(username);
        return new User(username, "", true, true, true, true, groups);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected GrantedAuthority[] loadGroups(String username) throws AuthenticationException {
        try {
            ArrayList<Object> authorities = new ArrayList<Object>();
            authorities.add(AUTHENTICATED_AUTHORITY);
            if (!StringUtils.isBlank((String)this.groupsCommandLine)) {
                StringWriter out = new StringWriter();
                Launcher.LocalLauncher launcher = new Launcher.LocalLauncher((TaskListener)new StreamTaskListener((Writer)out));
                ByteArrayOutputStream scriptOut = new ByteArrayOutputStream();
                if (launcher.launch().cmds(QuotedStringTokenizer.tokenize((String)this.groupsCommandLine)).stdout((OutputStream)scriptOut).envs(new String[]{"U=" + username}).join() == 0) {
                    StringTokenizer tokenizer = new StringTokenizer(scriptOut.toString().trim(), this.groupsDelimiter);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken().trim();
                        Object[] args = new String[]{token, username};
                        LOGGER.log(Level.FINE, "granting: {0} to {1}", args);
                        authorities.add(new GrantedAuthorityImpl(token));
                    }
                } else {
                    throw new BadCredentialsException(out.toString());
                }
            }
            return authorities.toArray(new GrantedAuthority[0]);
        }
        catch (InterruptedException e) {
            throw new AuthenticationServiceException("Interrupted", (Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationServiceException("Failed", (Throwable)e);
        }
    }
}

