/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.scriptler;

import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import hudson.util.RemotingDiagnostics;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.scriptler.Messages;
import org.jvnet.hudson.plugins.scriptler.config.Script;
import org.jvnet.hudson.plugins.scriptler.config.ScriptlerConfiguration;
import org.jvnet.hudson.plugins.scriptler.share.Catalog;
import org.jvnet.hudson.plugins.scriptler.share.CatalogEntry;
import org.jvnet.hudson.plugins.scriptler.share.CatalogInfo;
import org.jvnet.hudson.plugins.scriptler.share.CatalogManager;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@Extension
public class ScriptlerManagment
extends ManagementLink {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerManagment.class.getName());
    private ScriptlerConfiguration cfg = null;

    public String getIconFileName() {
        return "notepad.gif";
    }

    public String getUrlName() {
        return "scriptler";
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public ScriptlerManagment getScriptler() {
        return this;
    }

    public ScriptlerConfiguration getConfiguration() {
        if (this.cfg == null) {
            try {
                this.cfg = ScriptlerConfiguration.load();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to load scriptler configuration", e);
            }
        }
        return this.cfg;
    }

    public HttpResponse doDownloadScript(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="name") String name, @QueryParameter(value="catalog") String catalogName) throws IOException {
        CatalogInfo catInfo = this.getConfiguration().getCatalogInfo(catalogName);
        CatalogManager catalogManager = new CatalogManager(catInfo);
        Catalog catalog = catalogManager.loadCatalog();
        CatalogEntry entry = catalog.getEntryByName(name);
        String source = catalogManager.downloadScript(name);
        return this.doScriptAdd(res, rsp, name, entry.comment, source);
    }

    public HttpResponse doScriptAdd(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="name") String name, @QueryParameter(value="comment") String comment, @QueryParameter(value="script") String script) throws IOException {
        if (StringUtils.isEmpty((String)script) || StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name and script must not be empty");
        }
        name = this.fixFileName(name);
        File newScriptFile = new File(ScriptlerManagment.getScriptDirectory(), name);
        FileWriter writer = new FileWriter(newScriptFile);
        writer.write(script);
        ((Writer)writer).close();
        Script newScript = new Script(name, comment);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.addOrReplace(newScript);
        cfg.save();
        return new HttpRedirect("index");
    }

    public HttpResponse doRemoveScript(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="name") String name) throws IOException {
        File oldScript = new File(ScriptlerManagment.getScriptDirectory(), name);
        oldScript.delete();
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.removeScript(name);
        cfg.save();
        return new HttpRedirect("index");
    }

    public HttpResponse doUploadScript(StaplerRequest req) throws IOException, ServletException {
        try {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            File rootDir = ScriptlerManagment.getScriptDirectory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            FileItem fileItem = (FileItem)upload.parseRequest((HttpServletRequest)req).get(0);
            String fileName = Util.getFileName((String)fileItem.getName());
            if (StringUtils.isEmpty((String)fileName)) {
                return new HttpRedirect(".");
            }
            fileName = this.fixFileName(fileName);
            fileItem.write(new File(rootDir, fileName));
            Script script = this.getScript(fileName, false);
            if (script == null) {
                script = new Script(fileName, "uploaded");
            }
            ScriptlerConfiguration config = this.getConfiguration();
            config.addOrReplace(script);
            return new HttpRedirect("index");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected Script getScript(String scriptName, boolean withSrc) {
        Script s = this.getConfiguration().getScriptByName(scriptName);
        File scriptSrc = new File(ScriptlerManagment.getScriptDirectory(), scriptName);
        if (withSrc) {
            try {
                FileReader reader = new FileReader(scriptSrc);
                String src = IOUtils.toString((Reader)reader);
                s.setScript(src);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "not able to load sources for script [" + scriptName + "]", e);
            }
        }
        return s;
    }

    public void doRunScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="name") String scriptName) throws IOException, ServletException {
        Script script = this.getScript(scriptName, true);
        req.setAttribute("script", (Object)script);
        req.setAttribute("currentNode", (Object)"(master)");
        req.getView((Object)this, "runscript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doTriggerScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="scriptName") String scriptName, @QueryParameter(value="script") String script, @QueryParameter(value="node") String node) throws IOException, ServletException {
        this.checkPermission(Hudson.ADMINISTER);
        Script tempScript = this.getScript(scriptName, false);
        tempScript.setScript(script);
        req.setAttribute("script", (Object)tempScript);
        req.setAttribute("currentNode", (Object)node);
        String output = this.doScript(node, script);
        req.setAttribute("output", (Object)output);
        req.getView((Object)this, "runscript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    private String doScript(String node, String scriptTxt) throws IOException, ServletException {
        String output = "[no output]";
        if (node != null && scriptTxt != null) {
            try {
                Computer comp = Hudson.getInstance().getComputer(node);
                output = comp == null ? Messages.node_not_found((Object)node) : (comp.getChannel() == null ? Messages.node_not_online((Object)node) : RemotingDiagnostics.executeGroovy((String)scriptTxt, (VirtualChannel)comp.getChannel()));
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return output;
    }

    public void doEditScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="name") String scriptName) throws IOException, ServletException {
        Script script = this.getScript(scriptName, true);
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public List<String> getSlaveNames() {
        ComputerSet computers = Hudson.getInstance().getComputer();
        List slaveNames = computers.get_slaveNames();
        ArrayList<String> test = new ArrayList<String>();
        test.addAll(slaveNames);
        if (!test.contains("(master)")) {
            test.add("(master)");
        }
        return test;
    }

    public List<Catalog> getCatalogs() {
        ArrayList<Catalog> catalogs = new ArrayList<Catalog>();
        List catalogInfos = this.getConfiguration().getCatalogInfos();
        for (CatalogInfo catalogInfo : catalogInfos) {
            CatalogManager mgr = new CatalogManager(catalogInfo);
            Catalog catalog = mgr.loadCatalog();
            catalog.setInfo(catalogInfo);
            if (catalog == null) continue;
            catalogs.add(catalog);
        }
        return catalogs;
    }

    public static File getScriptDirectory() {
        return new File(ScriptlerManagment.getScriptlerHomeDirectory(), "scripts");
    }

    public static File getScriptlerHomeDirectory() {
        return new File(Hudson.getInstance().getRootDir(), "scriptler");
    }

    private void checkPermission(Permission permission) {
        Hudson.getInstance().checkPermission(permission);
    }

    private String fixFileName(String name) {
        if (!name.endsWith(".groovy")) {
            name = name + ".groovy";
        }
        name = name.replace(" ", "_").trim();
        return name;
    }
}

