/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.scriptler.share;

import hudson.ProxyConfiguration;
import hudson.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jvnet.hudson.plugins.scriptler.ScriptlerManagment;
import org.jvnet.hudson.plugins.scriptler.share.Catalog;
import org.jvnet.hudson.plugins.scriptler.share.CatalogInfo;

public class CatalogManager {
    private final CatalogInfo catalogInfo;

    public CatalogManager(CatalogInfo info) {
        this.catalogInfo = info;
    }

    void downloadDefaultScriptCatalog(File catalogFileTarget) {
        try {
            FileOutputStream out = new FileOutputStream(catalogFileTarget);
            Util.copyStreamAndClose((InputStream)ProxyConfiguration.open((URL)new URL(this.catalogInfo.catalogLocation)).getInputStream(), (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String downloadScript(String scriptName) {
        String source = null;
        try {
            String fileUrl = MessageFormat.format(this.catalogInfo.scriptDownloadUrl, scriptName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Util.copyStreamAndClose((InputStream)ProxyConfiguration.open((URL)new URL(fileUrl)).getInputStream(), (OutputStream)out);
            source = out.toString("UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return source;
    }

    public Catalog loadCatalog() {
        File catFile = new File(ScriptlerManagment.getScriptlerHomeDirectory(), this.catalogInfo.name + "-catalog.xml");
        this.downloadDefaultScriptCatalog(catFile);
        Catalog catalog = null;
        if (catFile.exists()) {
            try {
                catalog = Catalog.load((File)catFile);
                catalog.setInfo(this.catalogInfo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (catalog == null) {
            catalog = new Catalog(this.catalogInfo);
        }
        return catalog;
    }
}

