/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.scriptler.share;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jvnet.hudson.plugins.scriptler.share.CatalogEntry;
import org.jvnet.hudson.plugins.scriptler.share.CatalogInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Catalog {
    private transient CatalogInfo info;
    protected Set<CatalogEntry> entrySet = new HashSet<CatalogEntry>();
    private static final XStream XSTREAM = new XStream2();

    public Catalog(CatalogInfo info) {
        this.info = info;
    }

    public void setInfo(CatalogInfo info) {
        this.info = info;
    }

    public CatalogInfo getInfo() {
        return this.info;
    }

    public CatalogEntry getEntryByName(String name) {
        for (CatalogEntry scr : this.entrySet) {
            if (!scr.getName().equals(name)) continue;
            return scr;
        }
        return null;
    }

    public void removeCatalogEntry(String name) {
        CatalogEntry s = this.getEntryByName(name);
        this.entrySet.remove(s);
    }

    public void addOrReplace(CatalogEntry script) {
        if (script != null) {
            if (this.entrySet.contains(script)) {
                this.entrySet.remove(script);
            }
            this.entrySet.add(script);
        }
    }

    public final Set<CatalogEntry> getEntries() {
        return Collections.unmodifiableSet(this.entrySet);
    }

    public void setEntries(Set<CatalogEntry> scripts) {
        this.entrySet = scripts;
    }

    public synchronized void save(File catalogFile) throws IOException {
        XmlFile f = Catalog.getXmlFile(catalogFile);
        f.write((Object)this);
    }

    private static XmlFile getXmlFile(File file) {
        return new XmlFile(XSTREAM, file);
    }

    public static Catalog load(File catalogFile) throws IOException {
        XmlFile f = Catalog.getXmlFile(catalogFile);
        if (f.exists()) {
            Catalog sc = (Catalog)f.read();
            return sc;
        }
        return null;
    }

    static {
        XSTREAM.alias("catalog", Catalog.class);
        XSTREAM.alias("entry", CatalogEntry.class);
    }
}

