// CHECKSTYLE:OFF

package org.jvnet.hudson.plugins.scriptler;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * this script was discovered on the file system, please describe it!
     * 
     */
    public static String script_loaded_from_directory() {
        return holder.format("script_loaded_from_directory");
    }

    /**
     * this script was discovered on the file system, please describe it!
     * 
     */
    public static Localizable _script_loaded_from_directory() {
        return new Localizable(holder, "script_loaded_from_directory");
    }

    /**
     * Select a Groovy script from your local system to be uploaded. 
     * 
     */
    public static String uploadtext() {
        return holder.format("uploadtext");
    }

    /**
     * Select a Groovy script from your local system to be uploaded. 
     * 
     */
    public static Localizable _uploadtext() {
        return new Localizable(holder, "uploadtext");
    }

    /**
     * Scriptler
     * 
     */
    public static String display_name() {
        return holder.format("display_name");
    }

    /**
     * Scriptler
     * 
     */
    public static Localizable _display_name() {
        return new Localizable(holder, "display_name");
    }

    /**
     * this is not a groovy script: {0}
     * 
     */
    public static String not_groovy_script(Object arg1) {
        return holder.format("not_groovy_script", arg1);
    }

    /**
     * this is not a groovy script: {0}
     * 
     */
    public static Localizable _not_groovy_script(Object arg1) {
        return new Localizable(holder, "not_groovy_script", arg1);
    }

    /**
     * The scripts are stored at:
     * 
     */
    public static String scriptdirectorytitle() {
        return holder.format("scriptdirectorytitle");
    }

    /**
     * The scripts are stored at:
     * 
     */
    public static Localizable _scriptdirectorytitle() {
        return new Localizable(holder, "scriptdirectorytitle");
    }

    /**
     * The node [{0}] could not be found!
     * 
     */
    public static String node_not_found(Object arg1) {
        return holder.format("node_not_found", arg1);
    }

    /**
     * The node [{0}] could not be found!
     * 
     */
    public static Localizable _node_not_found(Object arg1) {
        return new Localizable(holder, "node_not_found", arg1);
    }

    /**
     * Store/edit/run scripts on any of the slaves or the master.
     * 
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Store/edit/run scripts on any of the slaves or the master.
     * 
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

    /**
     * The selected node [{0}] is not online, therefore the script can not be executed! Select an other node or start it before you try again.
     * 
     */
    public static String node_not_online(Object arg1) {
        return holder.format("node_not_online", arg1);
    }

    /**
     * The selected node [{0}] is not online, therefore the script can not be executed! Select an other node or start it before you try again.
     * 
     */
    public static Localizable _node_not_online(Object arg1) {
        return new Localizable(holder, "node_not_online", arg1);
    }

}
