/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.scriptler.config;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jvnet.hudson.plugins.scriptler.config.Script;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptSet {
    protected Set<Script> scriptSet = new TreeSet();

    public Script getScriptByName(String name) {
        for (Script scr : this.scriptSet) {
            if (!scr.name.equals(name)) continue;
            return scr;
        }
        return null;
    }

    public void removeScript(String name) {
        Script s = this.getScriptByName(name);
        this.scriptSet.remove(s);
    }

    public void addOrReplace(Script script) {
        if (script != null) {
            if (this.scriptSet.contains(script)) {
                Script oldScript = this.getScriptByName(script.name);
                Script mergedScript = this.merge(oldScript, script);
                this.scriptSet.remove(script);
                this.scriptSet.add(mergedScript);
            } else {
                this.scriptSet.add(script);
            }
        }
    }

    private Script merge(Script origin, Script newScript) {
        String comment = StringUtils.isEmpty((String)newScript.comment) ? origin.comment : newScript.comment;
        String originCatalog = StringUtils.isEmpty((String)newScript.originCatalog) ? origin.originCatalog : newScript.originCatalog;
        String originScript = StringUtils.isEmpty((String)newScript.originScript) ? origin.originScript : newScript.originScript;
        String originDate = StringUtils.isEmpty((String)newScript.originDate) ? origin.originDate : newScript.originDate;
        return new Script(origin.getName(), comment, newScript.available, originCatalog, originScript, originDate);
    }

    public final Set<Script> getScripts() {
        return Collections.unmodifiableSet(this.scriptSet);
    }

    public void setScripts(Set<Script> scripts) {
        this.scriptSet = scripts;
    }
}

