/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.scriptler;

import hudson.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.plugins.scriptler.Messages;
import org.jvnet.hudson.plugins.scriptler.ScriptlerManagment;
import org.jvnet.hudson.plugins.scriptler.config.Script;
import org.jvnet.hudson.plugins.scriptler.config.ScriptlerConfiguration;
import org.jvnet.hudson.plugins.scriptler.share.CatalogInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScritplerPluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(ScritplerPluginImpl.class.getName());
    private static String DEFAULT_LOCATION = "http://hudson.fortysix.ch/scriptler";
    private static String DEFAULT_CATALOG = DEFAULT_LOCATION + "/scriptler-catalog.xml";

    public void start() throws Exception {
        super.start();
        this.synchronizeConfig();
    }

    private void synchronizeConfig() throws IOException {
        File scriptDirectory;
        LOGGER.info("initialize scriptler");
        if (!ScriptlerManagment.getScriptlerHomeDirectory().exists()) {
            ScriptlerManagment.getScriptlerHomeDirectory().mkdirs();
        }
        if (!(scriptDirectory = ScriptlerManagment.getScriptDirectory()).exists()) {
            scriptDirectory.mkdirs();
        }
        List availablePhysicalScripts = this.getAvailableScripts();
        ScriptlerConfiguration cfg = ScriptlerConfiguration.load();
        if (cfg == null) {
            cfg = new ScriptlerConfiguration(new TreeSet());
        }
        for (File file : availablePhysicalScripts) {
            if (cfg.getScriptByName(file.getName()) != null) continue;
            cfg.addOrReplace(new Script(file.getName(), Messages.script_loaded_from_directory()));
        }
        HashSet<Script> unavailableScripts = new HashSet<Script>();
        for (Script s : cfg.getScripts()) {
            if (new File(scriptDirectory, s.name).exists()) continue;
            unavailableScripts.add(new Script(s.name, s.comment, false));
        }
        for (Script script : unavailableScripts) {
            cfg.addOrReplace(script);
        }
        List catalogInfos = cfg.getCatalogInfos();
        if (catalogInfos == null) {
            cfg.setCatalogInfos(new ArrayList());
        }
        Iterator iterator = catalogInfos.iterator();
        while (iterator.hasNext()) {
            CatalogInfo catalogInfo = (CatalogInfo)iterator.next();
            if (!catalogInfo.name.equals("default")) continue;
            iterator.remove();
        }
        if (catalogInfos.size() == 0) {
            CatalogInfo scriptlerWeb = new CatalogInfo("scriptlerweb", "http://scriptlerweb.appspot.com/catalog/xml", "http://scriptlerweb.appspot.com/script/show/{1}", "http://scriptlerweb.appspot.com/script/download/{1}");
            catalogInfos.add(scriptlerWeb);
        }
        cfg.save();
    }

    public List<File> getAvailableScripts() throws IOException {
        File scriptDirectory = ScriptlerManagment.getScriptDirectory();
        LOGGER.log(Level.FINE, "Listing files of {0}", scriptDirectory.getAbsoluteFile());
        File[] scriptFiles = scriptDirectory.listFiles();
        List<File> fileList = scriptFiles == null ? new ArrayList<File>() : Arrays.asList(scriptFiles);
        return fileList;
    }
}

