/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.scriptler.config;

import com.thoughtworks.xstream.XStream;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jvnet.hudson.plugins.scriptler.ScriptlerManagment;
import org.jvnet.hudson.plugins.scriptler.config.NamedResource;
import org.jvnet.hudson.plugins.scriptler.config.Script;
import org.jvnet.hudson.plugins.scriptler.config.ScriptSet;
import org.jvnet.hudson.plugins.scriptler.share.CatalogInfo;
import org.jvnet.hudson.plugins.scriptler.util.ByNameSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptlerConfiguration
extends ScriptSet
implements Saveable {
    private List<CatalogInfo> catalogInfos = new ArrayList<CatalogInfo>();
    private static final XStream XSTREAM = new XStream2();

    public ScriptlerConfiguration(SortedSet<Script> scripts) {
        if (scripts != null) {
            this.scriptSet = scripts;
        }
    }

    public List<CatalogInfo> getCatalogInfos() {
        return this.catalogInfos;
    }

    public void setCatalogInfos(List<CatalogInfo> catalogInfos) {
        this.catalogInfos = catalogInfos;
    }

    public CatalogInfo getCatalogInfo(String name) {
        for (CatalogInfo catInfo : this.getCatalogInfos()) {
            if (!catInfo.name.equals(name)) continue;
            return catInfo;
        }
        return null;
    }

    public synchronized void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        ScriptlerConfiguration.getXmlFile().write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)ScriptlerConfiguration.getXmlFile());
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(ScriptlerManagment.getScriptlerHomeDirectory(), "scriptler.xml"));
    }

    public static ScriptlerConfiguration load() throws IOException {
        XmlFile f = ScriptlerConfiguration.getXmlFile();
        if (f.exists()) {
            ScriptlerConfiguration sc = (ScriptlerConfiguration)f.read();
            TreeSet<NamedResource> sorted = new TreeSet<NamedResource>(new ByNameSorter());
            sorted.addAll(sc.getScripts());
            sc.setScripts(sorted);
            return sc;
        }
        return null;
    }

    static {
        XSTREAM.alias("scriptler", ScriptlerConfiguration.class);
        XSTREAM.alias("script", Script.class);
        XSTREAM.alias("catalog", CatalogInfo.class);
    }
}

