/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.util.DescribableList;
import hudson.views.BuildButtonColumn;
import hudson.views.JobColumn;
import hudson.views.LastDurationColumn;
import hudson.views.LastFailureColumn;
import hudson.views.LastSuccessColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListViewSection
extends SectionedViewSection {
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    private static final Logger LOGGER = Logger.getLogger(ListViewSection.class.getName());
    private static final List<Class<? extends ListViewColumn>> DEFAULT_COLUMNS = Arrays.asList(StatusColumn.class, WeatherColumn.class, JobColumn.class, LastSuccessColumn.class, LastFailureColumn.class, LastDurationColumn.class, BuildButtonColumn.class);

    @DataBoundConstructor
    public ListViewSection(String name, SectionedViewSection.Width width, SectionedViewSection.Positioning alignment) {
        super(name, width, alignment);
    }

    public Iterable<ListViewColumn> getColumns() {
        return this.columns;
    }

    public static List<ListViewColumn> getDefaultColumns() {
        ArrayList<Describable> r = new ArrayList<Describable>();
        DescriptorExtensionList all = ListViewColumn.all();
        for (Class d : DEFAULT_COLUMNS) {
            Descriptor des = all.find(d);
            if (des == null) continue;
            try {
                r.add(des.newInstance(null, null));
            }
            catch (Descriptor.FormException e) {
                LOGGER.log(Level.WARNING, "Failed to instantiate " + des.clazz, e);
            }
        }
        return Collections.unmodifiableList(r);
    }

    static /* synthetic */ DescribableList access$000(ListViewSection x0) {
        return x0.columns;
    }

    static /* synthetic */ DescribableList access$002(ListViewSection x0, DescribableList x1) {
        x0.columns = x1;
        return x0.columns;
    }
}

