/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.model.Hudson;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.plugins.sectioned_view.SectionedViewSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewListingSection
extends SectionedViewSection {
    private List<String> views;
    private int columns;

    @DataBoundConstructor
    public ViewListingSection(String name, SectionedViewSection.Width width, SectionedViewSection.Positioning alignment, List<String> views, int columns) {
        super(name, width, alignment);
        this.setViews(views);
        this.setColumns(columns);
    }

    public void setViews(List<String> views) {
        this.views = views;
    }

    public List<String> getViews() {
        return this.views;
    }

    public String getViewsString() {
        char delim = ',';
        StringBuilder buf = new StringBuilder();
        for (String value : this.views) {
            buf.append(delim).append(value);
        }
        return buf.substring(1);
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getColumns() {
        return this.columns;
    }

    public List<Collection<View>> getNestedViewColumns() {
        ArrayList<Collection<View>> nestedViewColumns = new ArrayList<Collection<View>>();
        for (int i = 0; i < this.columns; ++i) {
            nestedViewColumns.add(new ArrayList());
        }
        int column = 0;
        for (String viewName : this.views) {
            String[] viewComponents = viewName.split("\\$");
            View view = Hudson.getInstance().getView(viewComponents[0]);
            if (view == null) continue;
            boolean skipView = false;
            for (int i = 1; i < viewComponents.length; ++i) {
                if (view instanceof ViewGroup) {
                    if ((view = ((ViewGroup)view).getView(viewComponents[i])) != null) continue;
                    skipView = true;
                    break;
                }
                skipView = true;
                break;
            }
            if (skipView) continue;
            ((Collection)nestedViewColumns.get(column % this.columns)).add(view);
            ++column;
        }
        return nestedViewColumns;
    }
}

