/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.sectioned_view.SectionedView;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionedView
extends View {
    private DescribableList<SectionedViewSection, Descriptor<SectionedViewSection>> sections;

    public Iterable<SectionedViewSection> getSections() {
        return this.sections;
    }

    @DataBoundConstructor
    public SectionedView(String name) {
        super(name);
        this.initSections();
    }

    protected void initSections() {
        if (this.sections != null) {
            return;
        }
        this.sections = new DescribableList(Saveable.NOOP);
    }

    public static Collection<Job> sortJobs(Collection<Job> jobs) {
        TreeSet<Job> set = new TreeSet<Job>((Comparator<Job>)new JobComparator(null));
        if (jobs != null) {
            set.addAll(jobs);
        }
        return set;
    }

    public static boolean isBuilding(Job job) {
        Run lastBuild = job.getLastBuild();
        return lastBuild != null && (lastBuild.isLogUpdated() || lastBuild.isBuilding());
    }

    public static Result getResult(Job job) {
        Run lastBuild;
        for (lastBuild = job.getLastBuild(); lastBuild != null && (lastBuild.hasntStartedYet() || lastBuild.isBuilding() || lastBuild.isLogUpdated()); lastBuild = lastBuild.getPreviousBuild()) {
        }
        if (lastBuild != null) {
            return lastBuild.getResult();
        }
        return Result.NOT_BUILT;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException {
        if (this.sections == null) {
            this.sections = new DescribableList(Saveable.NOOP);
        }
        try {
            this.sections.rebuildHetero(req, req.getSubmittedForm(), (Collection)Hudson.getInstance().getDescriptorList(SectionedViewSection.class), "sections");
        }
        catch (IOException e) {
            throw new Descriptor.FormException("Error rebuilding list of sections.", (Throwable)e, "sections");
        }
    }

    public boolean contains(TopLevelItem item) {
        for (SectionedViewSection section : this.sections) {
            if (!section.contains(item)) continue;
            return true;
        }
        return false;
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Hudson.getInstance().doCreateItem(req, rsp);
    }

    public Collection<TopLevelItem> getItems() {
        TreeSet names = new TreeSet();
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>(names.size());
        for (SectionedViewSection section : this.sections) {
            items.addAll(section.getItems());
        }
        return items;
    }

    public void onJobRenamed(Item item, String oldName, String newName) {
        for (SectionedViewSection section : this.sections) {
            if (!section.jobNames.remove(oldName) || newName == null) continue;
            section.jobNames.add(newName);
        }
    }
}

