/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.DescribableList;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SectionedViewSection
implements ExtensionPoint,
Describable<SectionedViewSection> {
    final SortedSet<String> jobNames = new TreeSet(CaseInsensitiveComparator.INSTANCE);
    DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters;
    private String name;
    String includeRegex;
    transient Pattern includePattern;
    private Width width;
    private Positioning alignment;
    transient String css;

    public SectionedViewSection(String name, Width width, Positioning alignment) {
        this.name = name;
        this.width = width;
        this.alignment = alignment;
        this.determineCss();
        this.initJobFilters();
    }

    public static DescriptorExtensionList<SectionedViewSection, SectionedViewSectionDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(SectionedViewSection.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public Iterable<ViewJobFilter> getJobFilters() {
        return this.jobFilters;
    }

    public boolean hasJobFilterExtensions() {
        return !ViewJobFilter.all().isEmpty();
    }

    public Width getWidth() {
        return this.width;
    }

    public void setWidth(Width width) {
        this.width = width;
    }

    public Positioning getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Positioning alignment) {
        this.alignment = alignment;
    }

    public boolean contains(TopLevelItem item) {
        return this.jobNames.contains(item.getName());
    }

    protected Object readResolve() {
        if (this.includeRegex != null) {
            this.includePattern = Pattern.compile(this.includeRegex);
        }
        if (this.width == null) {
            this.width = Width.FULL;
        }
        if (this.alignment == null) {
            this.alignment = Positioning.CENTER;
        }
        this.determineCss();
        this.initJobFilters();
        return this;
    }

    private void determineCss() {
        StringBuffer css = new StringBuffer();
        css.append(this.width.getCss());
        css.append(this.alignment.getCss());
        if (this.width == Width.FULL || this.alignment == Positioning.CENTER) {
            css.append("clear: both; ");
        } else if (this.alignment == Positioning.LEFT) {
            css.append("clear: left; ");
        } else if (this.alignment == Positioning.RIGHT) {
            css.append("clear: right; ");
        }
        this.css = css.toString();
    }

    public Collection<TopLevelItem> getItems() {
        TreeSet<String> names = new TreeSet<String>(this.jobNames);
        if (this.includePattern != null) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                String itemName = item.getName();
                if (!this.includePattern.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
        }
        List<Object> items = new ArrayList<TopLevelItem>(names.size());
        for (String n : names) {
            TopLevelItem item = Hudson.getInstance().getItem(n);
            if (item == null) continue;
            items.add(item);
        }
        Iterable jobFilters = this.getJobFilters();
        List allItems = Hudson.getInstance().getItems();
        for (ViewJobFilter jobFilter : jobFilters) {
            items = jobFilter.filter(items, allItems, null);
        }
        return items;
    }

    protected void initJobFilters() {
        if (this.jobFilters != null) {
            return;
        }
        ArrayList r = new ArrayList();
        this.jobFilters = new DescribableList(Saveable.NOOP, r);
    }

    public SectionedViewSectionDescriptor getDescriptor() {
        return (SectionedViewSectionDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String getCss() {
        return this.css;
    }
}

