/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.views.ViewJobFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SectionedViewSectionDescriptor
extends Descriptor<SectionedViewSection> {
    protected SectionedViewSectionDescriptor(Class<? extends SectionedViewSection> clazz) {
        super(clazz);
    }

    protected SectionedViewSectionDescriptor() {
    }

    public SectionedViewSection newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        SectionedViewSection section = (SectionedViewSection)req.bindJSON(((Object)((Object)this)).getClass().getDeclaringClass(), formData);
        if (formData.get("useincluderegex") != null) {
            JSONObject merp = formData.getJSONObject("useincluderegex");
            section.includeRegex = Util.nullify((String)merp.getString("includeRegex"));
            try {
                section.includePattern = Pattern.compile(section.includeRegex);
            }
            catch (PatternSyntaxException e) {
                throw new Descriptor.FormException("Regular expression is invalid: " + e.getMessage(), (Throwable)e, "includeRegex");
            }
        } else {
            section.includeRegex = null;
            section.includePattern = null;
        }
        section.jobNames.clear();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            String escapedName = item.getName().replaceAll("\\.", "_");
            if (!formData.containsKey((Object)escapedName) || !formData.getBoolean(escapedName)) continue;
            section.jobNames.add(item.getName());
        }
        if (section.jobFilters == null) {
            section.jobFilters = new DescribableList(Saveable.NOOP);
        }
        try {
            section.jobFilters.rebuildHetero(req, formData, (Collection)ViewJobFilter.all(), "jobFilters");
        }
        catch (IOException e) {
            throw new Descriptor.FormException("Error rebuilding list of view job filters.", (Throwable)e, "jobFilters");
        }
        return section;
    }

    public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
        String v = Util.fixEmpty((String)value);
        if (v != null) {
            try {
                Pattern.compile(v);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)pse.getMessage());
            }
        }
        return FormValidation.ok();
    }
}

