/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.CaseInsensitiveComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SectionedViewSection
implements ExtensionPoint,
Describable<SectionedViewSection> {
    final SortedSet<String> jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    private String name;
    String includeRegex;
    transient Pattern includePattern;

    public SectionedViewSection(String name) {
        this.name = name;
    }

    public static DescriptorExtensionList<SectionedViewSection, SectionedViewSectionDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(SectionedViewSection.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public boolean contains(TopLevelItem item) {
        return this.jobNames.contains(item.getName());
    }

    protected Object readResolve() {
        if (this.includeRegex != null) {
            this.includePattern = Pattern.compile(this.includeRegex);
        }
        return this;
    }

    public Collection<TopLevelItem> getItems() {
        TreeSet<String> names = new TreeSet<String>(this.jobNames);
        if (this.includePattern != null) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                String itemName = item.getName();
                if (!this.includePattern.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
        }
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>(names.size());
        for (String n : names) {
            TopLevelItem item = Hudson.getInstance().getItem(n);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public SectionedViewSectionDescriptor getDescriptor() {
        return (SectionedViewSectionDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }
}

