/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.DescribableList;
import hudson.views.BuildButtonColumn;
import hudson.views.JobColumn;
import hudson.views.LastDurationColumn;
import hudson.views.LastFailureColumn;
import hudson.views.LastSuccessColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListViewSection
extends SectionedViewSection {
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    private static final Descriptor[] defaultColumnDescriptors = new Descriptor[]{StatusColumn.DESCRIPTOR, WeatherColumn.DESCRIPTOR, JobColumn.DESCRIPTOR, LastSuccessColumn.DESCRIPTOR, LastFailureColumn.DESCRIPTOR, LastDurationColumn.DESCRIPTOR, BuildButtonColumn.DESCRIPTOR};

    @DataBoundConstructor
    public ListViewSection(String name, SectionedViewSection.Width width, SectionedViewSection.Positioning alignment) {
        super(name, width, alignment);
        this.initColumns();
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.initColumns();
        return this;
    }

    protected void initColumns() {
        if (this.columns != null) {
            return;
        }
        ArrayList<Describable> r = new ArrayList<Describable>();
        DescriptorExtensionList all = ListViewColumn.all();
        ArrayList left = new ArrayList();
        left.addAll(all);
        for (Descriptor d : defaultColumnDescriptors) {
            Descriptor des = all.find(d.getClass().getName());
            if (des == null) continue;
            try {
                r.add(des.newInstance(null, null));
                left.remove(des);
            }
            catch (Descriptor.FormException e) {
                // empty catch block
            }
        }
        for (Descriptor d : left) {
            try {
                r.add(d.newInstance(null, null));
            }
            catch (Descriptor.FormException e) {}
        }
        Iterator filter = r.iterator();
        while (filter.hasNext()) {
            if (((ListViewColumn)filter.next()).shownByDefault()) continue;
            filter.remove();
        }
        this.columns = new DescribableList(Saveable.NOOP);
        try {
            this.columns.replaceBy(r);
        }
        catch (IOException ex) {
            Logger.getLogger(ListViewSection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public Iterable<ListViewColumn> getColumns() {
        return this.columns;
    }

    public static List<ListViewColumn> getDefaultColumns() {
        ArrayList<Describable> r = new ArrayList<Describable>();
        DescriptorExtensionList all = ListViewColumn.all();
        for (Descriptor d : defaultColumnDescriptors) {
            Descriptor des = all.find(d.getClass().getName());
            if (des == null) continue;
            try {
                r.add(des.newInstance(null, null));
            }
            catch (Descriptor.FormException e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(r);
    }

    public static final class DescriptorImpl
    extends SectionedViewSectionDescriptor {
        public SectionedViewSection newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ListViewSection section = (ListViewSection)super.newInstance(req, formData);
            if (section.columns == null) {
                section.columns = new DescribableList(Saveable.NOOP);
            }
            section.columns.rebuildHetero(req, formData, (Collection)Hudson.getInstance().getDescriptorList(ListViewColumn.class), "columns");
            return section;
        }

        public String getDisplayName() {
            return "List View Section";
        }
    }
}

