/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Hudson;
import hudson.model.TopLevelItem;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.EnumConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SectionedViewSection
implements ExtensionPoint,
Describable<SectionedViewSection> {
    final SortedSet<String> jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    private String name;
    String includeRegex;
    transient Pattern includePattern;
    private Width width;
    private Positioning alignment;
    transient String css;

    public SectionedViewSection(String name, Width width, Positioning alignment) {
        this.name = name;
        this.width = width;
        this.alignment = alignment;
        this.determineCss();
    }

    public static DescriptorExtensionList<SectionedViewSection, SectionedViewSectionDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(SectionedViewSection.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public Width getWidth() {
        return this.width;
    }

    public void setWidth(Width width) {
        this.width = width;
    }

    public Positioning getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Positioning alignment) {
        this.alignment = alignment;
    }

    public boolean contains(TopLevelItem item) {
        return this.jobNames.contains(item.getName());
    }

    protected Object readResolve() {
        if (this.includeRegex != null) {
            this.includePattern = Pattern.compile(this.includeRegex);
        }
        if (this.width == null) {
            this.width = Width.FULL;
        }
        if (this.alignment == null) {
            this.alignment = Positioning.CENTER;
        }
        this.determineCss();
        return this;
    }

    private void determineCss() {
        StringBuffer css = new StringBuffer();
        css.append(this.width.getCss());
        css.append(this.alignment.getCss());
        if (this.width == Width.FULL || this.alignment == Positioning.CENTER) {
            css.append("clear: both; ");
        } else if (this.alignment == Positioning.LEFT) {
            css.append("clear: left; ");
        } else if (this.alignment == Positioning.RIGHT) {
            css.append("clear: right; ");
        }
        this.css = css.toString();
    }

    public Collection<TopLevelItem> getItems() {
        TreeSet<String> names = new TreeSet<String>(this.jobNames);
        if (this.includePattern != null) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                String itemName = item.getName();
                if (!this.includePattern.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
        }
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>(names.size());
        for (String n : names) {
            TopLevelItem item = Hudson.getInstance().getItem(n);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public SectionedViewSectionDescriptor getDescriptor() {
        return (SectionedViewSectionDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public String getCss() {
        return this.css;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Width {
        FULL("Full", 100, "width: 100%; "),
        HALF("1/2", 50, "width: 50%; "),
        THIRD("1/3", 33, "width: 33%; "),
        TWO_THIRDS("2/3", 66, "width: 66%; ");

        private final String description;
        private final String css;
        private final int percent;

        public String getDescription() {
            return this.description;
        }

        public String getCss() {
            return this.css;
        }

        public int getPercent() {
            return this.percent;
        }

        public String getName() {
            return this.name();
        }

        private Width(String description, int percent, String css) {
            this.description = description;
            this.percent = percent;
            this.css = css;
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), Width.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Positioning {
        CENTER("Center", "margin-left: auto; margin-right: auto; "),
        LEFT("Left", "float: left; "),
        RIGHT("Right", "float: right; ");

        private final String description;
        private final String css;

        public String getDescription() {
            return this.description;
        }

        public String getCss() {
            return this.css;
        }

        public String getName() {
            return this.name();
        }

        private Positioning(String description, String css) {
            this.description = description;
            this.css = css;
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), Positioning.class);
        }
    }
}

