/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sectioned_view;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Saveable;
import hudson.plugins.sectioned_view.SectionedViewSection;
import hudson.plugins.sectioned_view.SectionedViewSectionDescriptor;
import hudson.util.DescribableList;
import hudson.views.BuildButtonColumn;
import hudson.views.JobColumn;
import hudson.views.LastDurationColumn;
import hudson.views.LastFailureColumn;
import hudson.views.LastSuccessColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListViewSection
extends SectionedViewSection {
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    private static final Logger LOGGER = Logger.getLogger(ListViewSection.class.getName());
    private static final List<Class<? extends ListViewColumn>> DEFAULT_COLUMNS = Arrays.asList(StatusColumn.class, WeatherColumn.class, JobColumn.class, LastSuccessColumn.class, LastFailureColumn.class, LastDurationColumn.class, BuildButtonColumn.class);

    @DataBoundConstructor
    public ListViewSection(String name, SectionedViewSection.Width width, SectionedViewSection.Positioning alignment) {
        super(name, width, alignment);
    }

    public Iterable<ListViewColumn> getColumns() {
        return this.columns;
    }

    public static List<ListViewColumn> getDefaultColumns() {
        ArrayList<Describable> r = new ArrayList<Describable>();
        DescriptorExtensionList all = ListViewColumn.all();
        for (Class<? extends ListViewColumn> d : DEFAULT_COLUMNS) {
            Descriptor des = all.find(d);
            if (des == null) continue;
            try {
                r.add(des.newInstance(null, null));
            }
            catch (Descriptor.FormException e) {
                LOGGER.log(Level.WARNING, "Failed to instantiate " + des.clazz, e);
            }
        }
        return Collections.unmodifiableList(r);
    }

    @Extension
    public static final class DescriptorImpl
    extends SectionedViewSectionDescriptor {
        public SectionedViewSection newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ListViewSection section = (ListViewSection)super.newInstance(req, formData);
            if (section.columns == null) {
                section.columns = new DescribableList(Saveable.NOOP);
            }
            section.columns.rebuildHetero(req, formData, (Collection)Hudson.getInstance().getDescriptorList(ListViewColumn.class), "columns");
            return section;
        }

        public String getDisplayName() {
            return "List View Section";
        }
    }
}

