/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.nocaptcha;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class SecurityRealmNoCaptcha
extends HudsonPrivateSecurityRealm {
    @DataBoundConstructor
    public SecurityRealmNoCaptcha() {
        super(true);
    }

    public void doCreateAccount(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.allowsSignup()) {
            rsp.sendError(401, "User sign up is prohibited");
            return;
        }
        boolean firstUser = !SecurityRealmNoCaptcha.hasSomeUser();
        User u = this.createAccount(req, rsp, false, "signup.jelly");
        if (u != null) {
            if (firstUser) {
                this.tryToMakeAdmin(u);
            }
            this.loginAndTakeBack(req, rsp, u);
        }
    }

    protected static boolean hasSomeUser() {
        for (User u : User.getAll()) {
            if (u.getProperty(HudsonPrivateSecurityRealm.Details.class) == null) continue;
            return true;
        }
        return false;
    }

    protected void tryToMakeAdmin(User u) {
        AuthorizationStrategy as = Hudson.getInstance().getAuthorizationStrategy();
        if (as instanceof GlobalMatrixAuthorizationStrategy) {
            GlobalMatrixAuthorizationStrategy ma = (GlobalMatrixAuthorizationStrategy)as;
            ma.add(Hudson.ADMINISTER, u.getId());
        }
    }

    protected void loginAndTakeBack(StaplerRequest req, StaplerResponse rsp, User u) throws ServletException, IOException {
        UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)u.getId(), (Object)req.getParameter("password1"));
        a = this.getSecurityComponents().manager.authenticate((Authentication)a);
        SecurityContextHolder.getContext().setAuthentication((Authentication)a);
        req.getView((Object)this, "success.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    protected User createAccount(StaplerRequest req, StaplerResponse rsp, boolean selfRegistration, String formView) throws ServletException, IOException {
        User user;
        req.setCharacterEncoding("UTF-8");
        HudsonPrivateSecurityRealm.SignupInfo si = new HudsonPrivateSecurityRealm.SignupInfo();
        req.bindParameters((Object)si);
        if (selfRegistration && !this.validateCaptcha(si.captcha)) {
            si.errorMessage = "Text didn't match the word shown in the image";
        }
        if (si.password1 != null && !si.password1.equals(si.password2)) {
            si.errorMessage = "Password didn't match";
        }
        if (si.password1 == null || si.password1.length() == 0) {
            si.errorMessage = "Password is required";
        }
        if (si.username == null || si.username.length() == 0) {
            si.errorMessage = "User name is required";
        } else {
            user = User.get((String)si.username);
            if (user.getProperty(HudsonPrivateSecurityRealm.Details.class) != null) {
                si.errorMessage = "User name is already taken. Did you forget the password?";
            }
        }
        if (si.fullname == null || si.fullname.length() == 0) {
            si.fullname = si.username;
        }
        if (si.email == null || !si.email.contains("@")) {
            si.errorMessage = "Invalid e-mail address";
        }
        if (si.errorMessage != null) {
            req.setAttribute("data", (Object)si);
            req.getView((Object)this, formView).forward((ServletRequest)req, (ServletResponse)rsp);
            return null;
        }
        user = this.createAccount(si.username, si.password1);
        user.addProperty((UserProperty)new Mailer.UserProperty(si.email));
        user.setFullName(si.fullname);
        user.save();
        return user;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Hudson's own user database (without a CAPTCHA)";
        }
    }
}

