/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.selenium.ComputerListenerImpl;
import hudson.plugins.selenium.PluginImpl;
import hudson.remoting.Callable;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComputerListenerImpl
extends ComputerListener
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ComputerListenerImpl.class.getName());

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        String masterName = PluginImpl.getMasterHostName();
        if (masterName == null) {
            listener.getLogger().println("Unable to determine the host name of the master. Skipping Selenium execution.");
            return;
        }
        String hostName = this.getHostName(c);
        if (hostName == null) {
            listener.getLogger().println("Unable to determine the host name. Skipping Selenium execution.");
            return;
        }
        int masterPort = ((PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class)).getPort();
        int nrc = c.getNumExecutors();
        StringBuilder labelList = new StringBuilder();
        for (Label l : c.getNode().getAssignedLabels()) {
            labelList.append('/');
            labelList.append(l);
        }
        labelList.append('/');
        c.getNode().getRootPath().actAsync((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getHostName(Computer c) throws IOException, InterruptedException {
        for (String address : (List)c.getChannel().call((Callable)new ListPossibleNames(null))) {
            try {
                InetAddress ia = InetAddress.getByName(address);
                if (!ia.isReachable(500)) continue;
                return ia.getCanonicalHostName();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to parse " + address, e);
            }
        }
        return null;
    }
}

