/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.selenium.PluginImpl;
import hudson.plugins.selenium.RemoteControlLauncher;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComputerListenerImpl
extends ComputerListener
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ComputerListenerImpl.class.getName());

    public void onOnline(Computer c, final TaskListener listener) throws IOException, InterruptedException {
        final String masterName = PluginImpl.getMasterHostName();
        if (masterName == null) {
            listener.getLogger().println("Unable to determine the host name of the master. Skipping Selenium execution.");
            return;
        }
        final String hostName = this.getHostName(c);
        if (hostName == null) {
            listener.getLogger().println("Unable to determine the host name. Skipping Selenium execution.");
            return;
        }
        final int masterPort = ((PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class)).getPort();
        final int nrc = c.getNumExecutors();
        final StringBuilder labelList = new StringBuilder();
        for (Label l : c.getNode().getAssignedLabels()) {
            labelList.append('/');
            labelList.append(l);
        }
        labelList.append('/');
        c.getNode().getRootPath().actAsync((FilePath.FileCallable)new FilePath.FileCallable<Object>(){

            public Object invoke(File f, VirtualChannel channel) throws IOException {
                try {
                    for (int i = 0; i < nrc; ++i) {
                        ServerSocket ss = new ServerSocket(0);
                        int port = ss.getLocalPort();
                        ss.close();
                        PluginImpl.createSeleniumRCVM(f, listener).callAsync((Callable)new RemoteControlLauncher("-host", hostName, "-port", String.valueOf(port), "-env", labelList.toString(), "-hubURL", "http://" + masterName + ":" + masterPort + "/"));
                    }
                }
                catch (Exception t) {
                    throw new IOException2("Selenium RC launch interrupted", (Throwable)t);
                }
                return null;
            }
        });
    }

    private String getHostName(Computer c) throws IOException, InterruptedException {
        for (String address : (List)c.getChannel().call((Callable)new ListPossibleNames())) {
            try {
                InetAddress ia = InetAddress.getByName(address);
                if (!ia.isReachable(500)) continue;
                return ia.getCanonicalHostName();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to parse " + address, e);
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListPossibleNames
    implements Callable<List<String>, IOException> {
        private static final long serialVersionUID = 1L;

        private ListPossibleNames() {
        }

        public List<String> call() throws IOException {
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    names.add(ia.getHostAddress());
                }
            }
            return names;
        }
    }
}

