/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import com.thoughtworks.selenium.grid.configuration.HubConfiguration;
import com.thoughtworks.selenium.grid.hub.HubRegistry;
import com.thoughtworks.selenium.grid.hub.HubServlet;
import com.thoughtworks.selenium.grid.hub.management.LifecycleManagerServlet;
import com.thoughtworks.selenium.grid.hub.management.RegistrationServlet;
import com.thoughtworks.selenium.grid.hub.management.UnregistrationServlet;
import com.thoughtworks.selenium.grid.hub.management.console.ConsoleServlet;
import hudson.plugins.selenium.HudsonEnvironmentManager;
import hudson.plugins.selenium.HudsonRemoteControlPool;
import hudson.remoting.Callable;
import java.lang.reflect.Field;
import javax.servlet.Servlet;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HubLauncher
implements Callable<Void, Exception> {
    private int port;

    public HubLauncher(int port) {
        this.port = port;
    }

    public Void call() throws Exception {
        HubRegistry r = HubRegistry.registry();
        Field pool = r.getClass().getDeclaredField("pool");
        pool.setAccessible(true);
        pool.set(r, new HudsonRemoteControlPool());
        Field env = r.getClass().getDeclaredField("environmentManager");
        env.setAccessible(true);
        env.set(r, new HudsonEnvironmentManager());
        r.gridConfiguration().getHub().setPort(this.port);
        this.start();
        return null;
    }

    private void start() throws Exception {
        HubConfiguration configuration = HubRegistry.registry().gridConfiguration().getHub();
        Server server = new Server(configuration.getPort());
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        Context root = new Context((HandlerContainer)contexts, "/", 1);
        root.addServlet(new ServletHolder((Servlet)new HubServlet()), "/selenium-server/driver/*");
        root.addServlet(new ServletHolder((Servlet)new ConsoleServlet()), "/console");
        root.addServlet(new ServletHolder((Servlet)new RegistrationServlet()), "/registration-manager/register");
        root.addServlet(new ServletHolder((Servlet)new UnregistrationServlet()), "/registration-manager/unregister");
        root.addServlet(new ServletHolder((Servlet)new LifecycleManagerServlet()), "/lifecycle-manager");
        server.start();
    }
}

