/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.FilePath;
import hudson.Plugin;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.selenium.HubLauncher;
import hudson.plugins.selenium.SeleniumRemoteControl;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.slaves.Channels;
import hudson.util.ClasspathBuilder;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.framework.io.LargeText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ExportedBean
public class PluginImpl
extends Plugin
implements Action,
Serializable {
    private int port = 4444;
    private String exclusionPatterns;
    private boolean rcBrowserSideLog;
    private boolean rcDebug;
    private String rcFirefoxProfileTemplate;
    private String rcLog;
    private transient Channel channel;
    private transient Future<?> hubLauncher;
    private static final long serialVersionUID = 1L;

    public void start() throws Exception {
        this.load();
        StreamTaskListener listener = new StreamTaskListener(this.getLogFile());
        File root = Hudson.getInstance().getRootDir();
        this.channel = PluginImpl.createSeleniumGridVM((File)root, (TaskListener)listener);
        this.hubLauncher = this.channel.callAsync((Callable)new HubLauncher(this.port));
        Hudson.getInstance().getActions().add(this);
    }

    public File getLogFile() {
        return new File(Hudson.getInstance().getRootDir(), "selenium.log");
    }

    public void configure(StaplerRequest req, JSONObject formData) {
        this.port = formData.getInt("port");
        this.exclusionPatterns = formData.getString("exclusionPatterns");
        this.rcLog = formData.getString("rcLog");
        this.rcDebug = formData.getBoolean("rcDebug");
        this.rcBrowserSideLog = formData.getBoolean("rcBrowserSideLog");
        this.rcFirefoxProfileTemplate = formData.getString("rcFirefoxProfileTemplate");
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void waitForHubLaunch() throws ExecutionException, InterruptedException {
        this.hubLauncher.get();
    }

    public String getIconFileName() {
        return "/plugin/selenium/24x24/selenium.png";
    }

    public String getDisplayName() {
        return "Selenium Grid";
    }

    public String getUrlName() {
        return "/selenium";
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported
    public int getPort() {
        return this.port;
    }

    @Exported
    public String getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    @Exported
    public String getRcLog() {
        return this.rcLog;
    }

    @Exported
    public boolean getRcBrowserSideLog() {
        return this.rcBrowserSideLog;
    }

    @Exported
    public boolean getRcDebug() {
        return this.rcDebug;
    }

    @Exported
    public String getRcFirefoxProfileTemplate() {
        return this.rcFirefoxProfileTemplate;
    }

    public void stop() throws Exception {
        this.channel.close();
    }

    @Exported(inline=true)
    public List<SeleniumRemoteControl> getRemoteControls() throws IOException, InterruptedException {
        if (this.channel == null) {
            return Collections.emptyList();
        }
        return (List)this.channel.call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static Channel createSeleniumGridVM(File rootDir, TaskListener listener) throws IOException, InterruptedException {
        FilePath distDir = PluginImpl.install((File)rootDir, (TaskListener)listener);
        return Channels.newJVM((String)"Selenium Grid", (TaskListener)listener, (FilePath)distDir, (ClasspathBuilder)new ClasspathBuilder().addAll(distDir, "lib/selenium-grid-hub-standalone-*.jar, lib/log4j-*.jar"), null);
    }

    static Channel createSeleniumRCVM(File rootDir, TaskListener listener) throws IOException, InterruptedException {
        FilePath distDir = PluginImpl.install((File)rootDir, (TaskListener)listener);
        return Channels.newJVM((String)"Selenium RC", (TaskListener)listener, (FilePath)distDir, (ClasspathBuilder)new ClasspathBuilder().addAll(distDir, "vendor/selenium-server-*.jar, lib/selenium-grid-remote-control-*.jar, lib/commons-httpclient-*.jar"), null);
    }

    private static FilePath install(File rootDir, TaskListener listener) throws IOException, InterruptedException {
        FilePath distDir = new FilePath(new File(rootDir, "selenium-grid"));
        distDir.installIfNecessaryFrom(PluginImpl.class.getResource("selenium-grid.tgz"), listener, "Installing Selenium Grid binaries");
        return distDir;
    }

    static String getMasterHostName() throws MalformedURLException {
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl == null) {
            return null;
        }
        URL url = new URL(rootUrl);
        return url.getHost();
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        new LargeText(this.getLogFile(), false).doProgressText(req, rsp);
    }
}

