/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.TaskListener;
import hudson.plugins.selenium.PluginImpl;
import hudson.slaves.ComputerListener;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.springframework.util.StringUtils;

public class ComputerListenerImpl
extends ComputerListener
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ComputerListenerImpl.class.getName());
    private static final String SEPARATOR = ",";

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        String masterName;
        LOGGER.fine("Examining if we need to start Selenium RC");
        PluginImpl p = (PluginImpl)Hudson.getInstance().getPlugin(PluginImpl.class);
        String exclusions = p.getExclusionPatterns();
        List<Object> exclusionPatterns = new ArrayList();
        if (StringUtils.hasText((String)exclusions)) {
            exclusionPatterns = Arrays.asList(exclusions.split(SEPARATOR));
        }
        if (exclusionPatterns.size() > 0) {
            for (Label l : c.getNode().getAssignedLabels()) {
                for (String string : exclusionPatterns) {
                    if (!l.toString().matches(string)) continue;
                    LOGGER.fine("Node " + c.getNode().getDisplayName() + " is excluded from Selenium Grid because its label '" + l + "' matches exclusion pattern '" + string + "'");
                    return;
                }
            }
        }
        if ((masterName = PluginImpl.getMasterHostName()) == null) {
            listener.getLogger().println("Unable to determine the host name of the master. Skipping Selenium execution.");
            return;
        }
        String hostName = c.getHostName();
        if (hostName == null) {
            listener.getLogger().println("Unable to determine the host name. Skipping Selenium execution.");
            return;
        }
        int masterPort = p.getPort();
        int n = c.getNumExecutors();
        StringBuilder labelList = new StringBuilder();
        for (Label l : c.getNode().getAssignedLabels()) {
            labelList.append('/');
            labelList.append(l);
        }
        labelList.append('/');
        ArrayList<String> userArgs = new ArrayList<String>();
        if (this.hasText(p.getRcLog())) {
            userArgs.add("-log");
            userArgs.add(p.getRcLog());
        }
        if (p.getRcBrowserSideLog()) {
            userArgs.add("-browserSideLog");
        }
        if (p.getRcDebug()) {
            userArgs.add("-debug");
        }
        if (p.getRcTrustAllSSLCerts()) {
            userArgs.add("-trustAllSSLCertificates");
        }
        if (this.hasText(p.getRcFirefoxProfileTemplate())) {
            userArgs.add("-firefoxProfileTemplate");
            userArgs.add(p.getRcFirefoxProfileTemplate());
        }
        try {
            p.waitForHubLaunch();
        }
        catch (ExecutionException e) {
            throw new IOException2("Failed to wait for the Hub launch to complete", (Throwable)e);
        }
        LOGGER.fine("Going to start " + n + " RCs on " + c.getName());
        c.getNode().getRootPath().actAsync((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean hasText(String s) {
        return s != null && s.trim().length() > 0;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

