/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import com.thoughtworks.selenium.grid.hub.Environment;
import com.thoughtworks.selenium.grid.hub.remotecontrol.DynamicRemoteControlPool;
import com.thoughtworks.selenium.grid.hub.remotecontrol.RemoteControlProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HudsonRemoteControlPool
implements DynamicRemoteControlPool {
    private final Set<RemoteControlProxy> all = new HashSet<RemoteControlProxy>();
    private final Map<String, RemoteControlProxy> sessions = new HashMap<String, RemoteControlProxy>();
    private static final Logger LOGGER = Logger.getLogger(HudsonRemoteControlPool.class.getName());

    public synchronized void register(RemoteControlProxy rc) {
        this.all.add(rc);
    }

    public synchronized boolean unregister(RemoteControlProxy rc) {
        return this.all.remove(rc);
    }

    public synchronized List<RemoteControlProxy> availableRemoteControls() {
        ArrayList<RemoteControlProxy> r = new ArrayList<RemoteControlProxy>(this.all.size());
        for (RemoteControlProxy rc : this.all) {
            if (!rc.canHandleNewSession()) continue;
            r.add(rc);
        }
        return r;
    }

    public synchronized List<RemoteControlProxy> reservedRemoteControls() {
        ArrayList<RemoteControlProxy> r = new ArrayList<RemoteControlProxy>(this.all.size());
        for (RemoteControlProxy rc : this.all) {
            if (rc.concurrentSesssionCount() <= 0) continue;
            r.add(rc);
        }
        return r;
    }

    public synchronized RemoteControlProxy reserve(Environment env) {
        String[] keys = env.name().split("&");
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = '/' + keys[i] + '/';
        }
        while (true) {
            boolean hadMatch = false;
            for (RemoteControlProxy rc : this.all) {
                if (!(hadMatch |= this.matches(rc, keys)) || !rc.canHandleNewSession()) continue;
                rc.registerNewSession();
                return rc;
            }
            if (!hadMatch) {
                if (this.all.isEmpty()) {
                    throw new IllegalArgumentException("No RCs available");
                }
                throw new IllegalArgumentException("No RC satisifies the label criteria: " + env.name() + " - " + this.all);
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted while reserving remote control for " + env.name(), e);
                continue;
            }
            break;
        }
    }

    private boolean matches(RemoteControlProxy rc, String[] keys) {
        for (String key : keys) {
            if (rc.environment().contains(key)) continue;
            return false;
        }
        return true;
    }

    public synchronized void release(RemoteControlProxy rc) {
        rc.unregisterSession();
        this.notifyAll();
    }

    public synchronized void associateWithSession(RemoteControlProxy rc, String sessionId) {
        RemoteControlProxy old = this.sessions.put(sessionId, rc);
        if (old != null) {
            throw new IllegalStateException("Session ID " + sessionId + " is already used by " + old);
        }
    }

    public synchronized RemoteControlProxy retrieve(String sessionId) {
        return this.sessions.get(sessionId);
    }

    public synchronized void releaseForSession(String sessionId) {
        this.sessions.remove(sessionId).unregisterSession();
    }
}

