/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium;

import com.thoughtworks.selenium.grid.hub.remotecontrol.RemoteControlProxy;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class SeleniumRemoteControl
implements Comparable<SeleniumRemoteControl>,
Serializable {
    private final boolean isReserved;
    private final String host;
    private final int port;
    private final String environment;
    private static final long serialVersionUID = 1L;

    public SeleniumRemoteControl(RemoteControlProxy proxy, boolean reserved) {
        this.host = proxy.host();
        this.port = proxy.port();
        this.environment = proxy.environment();
        this.isReserved = reserved;
    }

    public String getHostAndPort() {
        return this.host + ':' + this.port;
    }

    @Exported
    public String getHost() {
        return this.host;
    }

    @Exported
    public int getPort() {
        return this.port;
    }

    @Exported
    public String getEnvironment() {
        return this.environment;
    }

    @Exported
    public boolean isReserved() {
        return this.isReserved;
    }

    public String getStatus() {
        if (this.isReserved) {
            return "In use";
        }
        return "Idle";
    }

    @Override
    public int compareTo(SeleniumRemoteControl that) {
        int r = this.getHost().compareTo(that.getHost());
        if (r != 0) {
            return r;
        }
        return this.getPort() - that.getPort();
    }
}

