/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.seleniumhq.TestResult;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqBuildAction
implements Action,
Serializable {
    private transient WeakReference<TestResult> result;
    private static final long serialVersionUID = 1L;
    public final AbstractBuild<?, ?> owner;
    private static final Logger logger = Logger.getLogger(SeleniumhqBuildAction.class.getName());
    private static final XStream XSTREAM = new XStream2();

    public SeleniumhqBuildAction(AbstractBuild<?, ?> owner, TestResult result, BuildListener listener) {
        this.owner = owner;
        try {
            this.getDataFile().write((Object)result);
        }
        catch (IOException e) {
            e.printStackTrace(listener.fatalError("Failed to save the Selenium test result"));
        }
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.owner.getRootDir(), "seleniumhqResult.xml"));
    }

    public Object getTarget() {
        return this.getResult();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Selenium Report";
    }

    public String getUrlName() {
        return "seleniumhq";
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public synchronized TestResult getResult() {
        TestResult r;
        if (this.result == null) {
            r = this.load();
            this.result = new WeakReference<TestResult>(r);
        } else {
            r = (TestResult)this.result.get();
        }
        if (r == null) {
            r = this.load();
            this.result = new WeakReference<TestResult>(r);
        }
        return r;
    }

    public synchronized SeleniumhqBuildAction getPreviousResult() {
        SeleniumhqBuildAction r;
        AbstractBuild b = this.owner;
        do {
            if ((b = (AbstractBuild)b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.FAILURE || (r = (SeleniumhqBuildAction)b.getAction(SeleniumhqBuildAction.class)) == null);
        return r;
    }

    private TestResult load() {
        TestResult r;
        try {
            r = (TestResult)this.getDataFile().read();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load " + this.getDataFile(), e);
            r = new TestResult();
        }
        return r;
    }
}

