/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.seleniumhq.FileUtil;
import hudson.plugins.seleniumhq.SeleniumhqBuilder;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqBuilder
extends Builder {
    private final String browser;
    private final String startURL;
    private final String suiteFile;
    private final String resultFile;
    private final String other;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SeleniumhqBuilder(String browser, String startURL, String suiteFile, String resultFile, String other) {
        this.browser = browser;
        this.startURL = startURL;
        this.suiteFile = suiteFile;
        this.resultFile = resultFile;
        this.other = other;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getStartURL() {
        return this.startURL;
    }

    public String getSuiteFile() {
        return this.suiteFile;
    }

    public String getOther() {
        return this.other;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public boolean isURLSuiteFile() {
        try {
            URL url = new URL(this.suiteFile);
            return url != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFileSuiteFile() {
        if (new File(this.suiteFile).exists()) {
            File file = new File(this.suiteFile);
            return file.isFile();
        }
        return false;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!DESCRIPTOR.isGoodSeleniumRunner()) {
            listener.error("Please configure the Selenium Remote Control htmlSuite Runner in admin of hudson");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getBrowser() == null || this.getBrowser().length() == 0) {
            listener.error("Build config : browser field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getStartURL() == null || this.getStartURL().length() == 0) {
            listener.error("Build config : startURL field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getSuiteFile() == null || this.getSuiteFile().length() == 0) {
            listener.error("Build config : suiteFile field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getResultFile() == null || this.getResultFile().length() == 0) {
            listener.error("Build config : resultFile field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        String suiteFile = null;
        FilePath tempSuite = null;
        if (this.isFileSuiteFile()) {
            suiteFile = this.suiteFile;
        } else if (this.isURLSuiteFile()) {
            tempSuite = build.getProject().getWorkspace().createTempFile("tempHtmlSuite", "html");
            FileUtils.copyURLToFile((URL)new URL(this.suiteFile), (File)new File(tempSuite.toURI()));
            suiteFile = tempSuite.toURI().getPath();
        } else {
            listener.error("The suiteFile is not a file or an url ! Check your buil configuration.");
            build.setResult(Result.FAILURE);
            return false;
        }
        String seleniumRunner = FileUtil.getExecutableAbsolutePath((String)DESCRIPTOR.getSeleniumRunner());
        String cmd = String.format("java -jar \"%1$s\" %2$s -htmlSuite \"%3$s\" \"%4$s\" \"%5$s\" \"%6$s\"", seleniumRunner, this.getOther() != null ? this.getOther() : "", this.getBrowser(), this.getStartURL(), suiteFile, this.getResultFile());
        launcher.launch(cmd, build.getEnvVars(), (OutputStream)listener.getLogger(), build.getProject().getWorkspace()).join();
        if (tempSuite != null) {
            tempSuite.delete();
        }
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

