/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.FilePath;
import hudson.Functions;
import hudson.model.AbstractItem;
import hudson.model.Actionable;
import hudson.model.Build;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Project;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.plugins.seleniumhq.SeleniumhqBuildAction;
import hudson.plugins.seleniumhq.SeleniumhqProjectAction;
import hudson.plugins.seleniumhq.SeleniumhqPublisher;
import hudson.util.Area;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqProjectAction
extends Actionable
implements ProminentProjectAction {
    private final Project<?, ?> project;

    public SeleniumhqProjectAction(Project<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "Selenium Report";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "seleniumhq";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        FilePath rootTarget;
        File rootFile = SeleniumhqPublisher.getSeleniumReportDir((AbstractItem)this.project);
        if (!rootFile.exists()) {
            rootFile.mkdir();
        }
        if ((rootTarget = new FilePath(rootFile)).list().size() == 0) {
            String index = "<html><head><title>Selenium result</title></head><body><center><br/><h2>No Selenium Test Result</h2></center></body></html>";
            OutputStream output = rootTarget.child("index.html").write();
            output.write(index.getBytes());
            output.close();
        }
        new DirectoryBrowserSupport((ModelObject)this, "Seleniumhq").serveFile(req, rsp, rootTarget, "graph.gif", false);
    }

    public SeleniumhqBuildAction getLastResult() {
        for (Build b = (Build)this.project.getLastBuild(); b != null; b = (Build)b.getPreviousBuild()) {
            SeleniumhqBuildAction r;
            if (b.getResult() == Result.FAILURE || (r = (SeleniumhqBuildAction)b.getAction(SeleniumhqBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null || this.getLastResult() == null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        if (req.checkIfModified(((Build)this.project.getLastBuild()).getTimestamp(), rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(req, this.buildDataSet()), (Area)this.calcDefaultSize());
    }

    private CategoryDataset buildDataSet() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (SeleniumhqBuildAction a = this.getLastResult(); a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getOwner());
            dsb.add((Number)a.getResult().getNumTestPasses(), (Comparable)((Object)"passes"), (Comparable)label);
            dsb.add((Number)a.getResult().getNumTestFailures(), (Comparable)((Object)"failed"), (Comparable)label);
        }
        return dsb.build();
    }

    private Area calcDefaultSize() {
        Area res = Functions.getScreenResolution();
        if (res != null && res.width <= 800) {
            return new Area(250, 100);
        }
        return new Area(500, 200);
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset) {
        String relPath = this.getRelPath(req);
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        1 ar = new /* Unavailable Anonymous Inner Class!! */;
        plot.setRenderer((CategoryItemRenderer)ar);
        ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
        ar.setSeriesPaint(1, (Paint)ColorPalette.BLUE);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private String getRelPath(StaplerRequest req) {
        String relPath = req.getParameter("rel");
        if (relPath == null) {
            return "";
        }
        return relPath;
    }
}

