/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.EnvVars;
import hudson.Util;
import java.io.File;

public class FileUtil {
    public static String getExecutableAbsolutePath(String exe) {
        if (exe == null) {
            return exe;
        }
        if (exe.indexOf(File.separatorChar) >= 0) {
            File f = new File(exe);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            File fexe = new File(exe + ".exe");
            if (fexe.exists()) {
                return fexe.getAbsolutePath();
            }
            return exe;
        }
        String path = (String)EnvVars.masterEnvVars.get("PATH");
        String tokenizedPath = "";
        String delimiter = null;
        if (path != null) {
            for (String _dir : Util.tokenize((String)path.replace("\\", "\\\\"), (String)File.pathSeparator)) {
                if (delimiter == null) {
                    delimiter = ", ";
                } else {
                    tokenizedPath = tokenizedPath + delimiter;
                }
                tokenizedPath = tokenizedPath + _dir.replace('\\', '/');
                File dir = new File(_dir);
                File f = new File(dir, exe);
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
                File fexe = new File(dir, exe + ".exe");
                if (!fexe.exists()) continue;
                return fexe.getAbsolutePath();
            }
            String string = tokenizedPath + ".";
        }
        return exe;
    }
}

