/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.seleniumhq.FileUtil;
import hudson.plugins.seleniumhq.SeleniumhqBuilder;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqBuilder
extends Builder {
    private final String browser;
    private final String startURL;
    private final String suiteFile;
    private final String resultFile;
    private final String other;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SeleniumhqBuilder(String browser, String startURL, String suiteFile, String resultFile, String other) {
        this.browser = browser;
        this.startURL = startURL;
        this.suiteFile = suiteFile;
        this.resultFile = resultFile;
        this.other = other;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getStartURL() {
        return this.startURL;
    }

    public String getSuiteFile() {
        return this.suiteFile;
    }

    public String getOther() {
        return this.other;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public boolean isURLSuiteFile() {
        try {
            URL url = new URL(this.suiteFile);
            return url != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFileSuiteFile(Build build, Launcher launcher) throws IOException, InterruptedException {
        FilePath suiteFilePath = new FilePath(build.getProject().getWorkspace(), this.suiteFile);
        if (suiteFilePath.exists()) {
            return !suiteFilePath.isDirectory();
        }
        suiteFilePath = new FilePath(launcher.getChannel(), this.suiteFile);
        if (suiteFilePath.exists()) {
            return !suiteFilePath.isDirectory();
        }
        return false;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!DESCRIPTOR.isGoodSeleniumRunner()) {
            listener.error("Please configure the Selenium Remote Control htmlSuite Runner in admin of hudson");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getBrowser() == null || this.getBrowser().length() == 0) {
            listener.error("Build config : browser field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getStartURL() == null || this.getStartURL().length() == 0) {
            listener.error("Build config : startURL field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getSuiteFile() == null || this.getSuiteFile().length() == 0) {
            listener.error("Build config : suiteFile field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getResultFile() == null || this.getResultFile().length() == 0) {
            listener.error("Build config : resultFile field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        String suiteFile = null;
        FilePath tempSuite = null;
        if (this.isFileSuiteFile(build, launcher)) {
            FilePath suiteFilePath = new FilePath(build.getProject().getWorkspace(), this.suiteFile);
            if (!suiteFilePath.exists()) {
                suiteFilePath = new FilePath(launcher.getChannel(), this.suiteFile);
            }
            suiteFile = suiteFilePath.getRemote();
        } else if (this.isURLSuiteFile()) {
            tempSuite = build.getProject().getWorkspace().createTempFile("tempHtmlSuite", "html");
            suiteFile = tempSuite.getRemote();
            try {
                File localWorkspace = new File(build.getProject().getRootDir(), "workspace");
                File tempSuiteLocal = File.createTempFile("tempHtmlSuite", "html");
                listener.getLogger().println("Try downloading suite file on master");
                listener.getLogger().println("    from url : " + this.suiteFile);
                listener.getLogger().println("    to file  : " + tempSuiteLocal.getPath());
                FileUtils.copyURLToFile((URL)new URL(this.suiteFile), (File)tempSuiteLocal);
                listener.getLogger().println("    ...");
                listener.getLogger().println("    Succeed");
                listener.getLogger().println("Try transfer suite file on slave");
                listener.getLogger().println("    from file : " + tempSuiteLocal.getPath());
                listener.getLogger().println("    to file   : " + suiteFile);
                FilePath sourceFile = new FilePath(tempSuiteLocal);
                sourceFile.copyTo(tempSuite);
                listener.getLogger().println("    ...");
                listener.getLogger().println("    Succeed");
                sourceFile.delete();
            }
            catch (Exception e) {
                listener.error("Downloading suite file from url failed ! Check your build configuration. ");
                build.setResult(Result.FAILURE);
                return false;
            }
        } else {
            listener.error("The suiteFile is not a file or an url ! Check your build configuration.");
            build.setResult(Result.FAILURE);
            return false;
        }
        String seleniumRunner = FileUtil.getExecutableAbsolutePath((String)DESCRIPTOR.getSeleniumRunner());
        FilePath resultFilePath = new FilePath(build.getProject().getWorkspace(), this.resultFile);
        resultFilePath.getParent().mkdirs();
        String resultFile = resultFilePath.getRemote();
        String cmd = String.format("java -jar \"%1$s\" %2$s -htmlSuite \"%3$s\" \"%4$s\" \"%5$s\" \"%6$s\"", seleniumRunner, this.getOther() != null ? this.getOther() : "", this.getBrowser(), this.getStartURL(), suiteFile, resultFile);
        launcher.launch(cmd, build.getEnvVars(), (OutputStream)listener.getLogger(), build.getProject().getWorkspace()).join();
        if (tempSuite != null) {
            tempSuite.delete();
        }
        return true;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }
}

