/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.seleniumhq.AbortException;
import hudson.plugins.seleniumhq.SeleniumhqBuildAction;
import hudson.plugins.seleniumhq.SeleniumhqProjectAction;
import hudson.plugins.seleniumhq.TestResult;
import hudson.remoting.VirtualChannel;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String testResults;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SeleniumhqPublisher(String testResults) {
        this.testResults = testResults;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new SeleniumhqProjectAction(project);
    }

    public static File getSeleniumReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "seleniumhq");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SeleniumhqBuildAction action;
        listener.getLogger().println("Publishing Selenium report...");
        FilePath rootTarget = new FilePath(SeleniumhqPublisher.getSeleniumReportDir((AbstractItem)build.getParent()));
        rootTarget.deleteContents();
        try {
            final long buildTime = build.getTimestamp().getTimeInMillis();
            final long nowMaster = System.currentTimeMillis();
            FilePath workspacePath = build.getProject().getWorkspace();
            TestResult result = (TestResult)workspacePath.act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){
                private static final long serialVersionUID = 1L;

                public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                    long nowSlave = System.currentTimeMillis();
                    FileSet fs = Util.createFileSet((File)ws, (String)SeleniumhqPublisher.this.testResults);
                    DirectoryScanner ds = fs.getDirectoryScanner();
                    String[] files = ds.getIncludedFiles();
                    if (files.length == 0) {
                        throw new AbortException("No Test Report Found");
                    }
                    return new TestResult(buildTime + (nowSlave - nowMaster), ds);
                }
            });
            if (result.getNumTestTotal() == 0) {
                throw new AbortException("Result does not have test");
            }
            action = new SeleniumhqBuildAction(build, result, listener);
            List<String> files = result.getFiles();
            if (files.size() == 1) {
                FilePath source = new FilePath(build.getProject().getWorkspace(), files.get(0));
                source.copyTo(new FilePath(rootTarget, "index.html"));
            } else {
                String header = "<html><head><title>Selenium result</title></head><body><center><br/><h2>Selenium Test Result</h2><ul>";
                String footer = "</ul></center></body></html>";
                OutputStream output = rootTarget.child("index.html").write();
                output.write(header.getBytes());
                int index = 0;
                for (String file : files) {
                    FilePath source = new FilePath(build.getProject().getWorkspace(), file);
                    String dest = index + "/" + source.getName();
                    source.copyTo(new FilePath(rootTarget, dest));
                    String link = "<li><a href=\"" + dest + "\">" + source.getName() + "</a></li>";
                    output.write(link.getBytes());
                    ++index;
                }
                output.write(footer.getBytes());
                output.close();
            }
        }
        catch (IOException e) {
            listener.error("Failed to archive Selenium reports");
            listener.error(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        catch (AbortException e) {
            if (build.getResult() != Result.FAILURE) {
                listener.error(e.getMessage());
                build.setResult(Result.FAILURE);
            }
            return true;
        }
        build.getActions().add(action);
        listener.getLogger().println("  Test failures: " + action.getResult().getNumTestFailures());
        listener.getLogger().println("  Test totals  : " + action.getResult().getNumTestTotal());
        if (action.getResult().getNumTestFailures() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        public DescriptorImpl() {
            super(SeleniumhqPublisher.class);
        }

        public String getDisplayName() {
            return "Publish Selenium Report";
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            req.bindParameters((Object)this, "seleniumhq.");
            this.save();
            return super.configure(req);
        }

        public void doCheck(StaplerRequest req, StaplerResponse rsp, @QueryParameter String value) throws IOException, ServletException {
            new FormFieldValidator.WorkspaceFileMask(req, rsp).process();
        }

        public SeleniumhqPublisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            SeleniumhqPublisher instance = (SeleniumhqPublisher)req.bindParameters(SeleniumhqPublisher.class, "seleniumhq.");
            return instance;
        }

        public String getHelpFile() {
            return "/plugin/seleniumhq/help-publisher.html";
        }
    }
}

