/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.seleniumhq.AbortException;
import hudson.plugins.seleniumhq.SeleniumhqBuildAction;
import hudson.plugins.seleniumhq.SeleniumhqProjectAction;
import hudson.plugins.seleniumhq.TestResult;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String testResults;
    private final boolean useTestCommands;

    @DataBoundConstructor
    public SeleniumhqPublisher(String testResults, boolean useTestCommands) {
        this.testResults = testResults;
        this.useTestCommands = useTestCommands;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public Boolean getUseTestCommands() {
        return this.useTestCommands;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return project instanceof Project ? new SeleniumhqProjectAction((Project)project) : null;
    }

    public static File getSeleniumReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "seleniumhq");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SeleniumhqBuildAction action;
        listener.getLogger().println("Publishing Selenium report...");
        FilePath rootTarget = new FilePath(SeleniumhqPublisher.getSeleniumReportDir((AbstractItem)build.getParent()));
        rootTarget.deleteContents();
        try {
            final long buildTime = build.getTimestamp().getTimeInMillis();
            final long nowMaster = System.currentTimeMillis();
            FilePath workspacePath = build.getWorkspace();
            TestResult result = (TestResult)workspacePath.act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){
                private static final long serialVersionUID = 1L;

                public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                    long nowSlave = System.currentTimeMillis();
                    FileSet fs = Util.createFileSet((File)ws, (String)SeleniumhqPublisher.this.testResults);
                    DirectoryScanner ds = fs.getDirectoryScanner();
                    String[] files = ds.getIncludedFiles();
                    if (files.length == 0) {
                        throw new AbortException("No Test Report Found");
                    }
                    return new TestResult(buildTime + (nowSlave - nowMaster), ds);
                }
            });
            if (result.getNumTestTotal() == 0) {
                throw new AbortException("Result does not have test");
            }
            action = new SeleniumhqBuildAction(build, result, listener);
            List<String> files = result.getFiles();
            if (files.size() == 1) {
                FilePath source = new FilePath(build.getWorkspace(), files.get(0));
                source.copyTo(new FilePath(rootTarget, "index.html"));
            } else {
                String header = "<html><head><title>Selenium result</title></head><body><center><br/><h2>Selenium Test Result</h2><ul>";
                String footer = "</ul></center></body></html>";
                OutputStream output = rootTarget.child("index.html").write();
                output.write(header.getBytes());
                int index = 0;
                for (String file : files) {
                    FilePath source = new FilePath(build.getWorkspace(), file);
                    String dest = index + "/" + source.getName();
                    source.copyTo(new FilePath(rootTarget, dest));
                    String link = "<li><a href=\"" + dest + "\">" + source.getName() + "</a></li>";
                    output.write(link.getBytes());
                    ++index;
                }
                output.write(footer.getBytes());
                output.close();
            }
        }
        catch (IOException e) {
            listener.error("Failed to archive Selenium reports");
            listener.error(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        catch (AbortException e) {
            if (build.getResult() != Result.FAILURE) {
                listener.error(e.getMessage());
                build.setResult(Result.FAILURE);
            }
            return true;
        }
        build.getActions().add(action);
        listener.getLogger().println("  Test failures: " + action.getResult().getNumTestFailures());
        listener.getLogger().println("  Test totals  : " + action.getResult().getNumTestTotal());
        listener.getLogger().println("------------------------");
        listener.getLogger().println("  Command Passes   : " + action.getResult().numCommandPasses());
        listener.getLogger().println("  Command Failures : " + action.getResult().numCommandFailures());
        listener.getLogger().println("  Command Errors   : " + action.getResult().numCommandErrors());
        if (this.useTestCommands) {
            if (action.getResult().numCommandFailures() > 0) {
                build.setResult(Result.UNSTABLE);
            }
            if (action.getResult().numCommandErrors() > 0) {
                build.setResult(Result.FAILURE);
            }
        } else if (action.getResult().getNumTestFailures() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(SeleniumhqPublisher.class);
        }

        public String getDisplayName() {
            return "Publish Selenium Report";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "seleniumhq.");
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Project.class.isAssignableFrom(jobType);
        }

        public SeleniumhqPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            SeleniumhqPublisher instance = (SeleniumhqPublisher)req.bindParameters(SeleniumhqPublisher.class, "seleniumhq.");
            return instance;
        }

        public String getHelpFile() {
            return "/plugin/seleniumhq/help-publisher.html";
        }
    }
}

