/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.seleniumhq.AbortException;
import hudson.plugins.seleniumhq.SeleniumhqBuildAction;
import hudson.plugins.seleniumhq.SeleniumhqProjectAction;
import hudson.plugins.seleniumhq.TestResult;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SeleniumhqPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String testResults;
    private final boolean useTestCommands;

    @DataBoundConstructor
    public SeleniumhqPublisher(String testResults, boolean useTestCommands) {
        this.testResults = testResults;
        this.useTestCommands = useTestCommands;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public Boolean getUseTestCommands() {
        return this.useTestCommands;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return project instanceof Project ? new SeleniumhqProjectAction((Project)project) : null;
    }

    public static File getSeleniumReportDir(AbstractItem project) {
        return new File(project.getRootDir(), "seleniumhq");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        SeleniumhqBuildAction action;
        listener.getLogger().println("Publishing Selenium report...");
        FilePath rootTarget = new FilePath(SeleniumhqPublisher.getSeleniumReportDir((AbstractItem)build.getParent()));
        rootTarget.deleteContents();
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            long nowMaster = System.currentTimeMillis();
            FilePath workspacePath = build.getWorkspace();
            TestResult result = (TestResult)workspacePath.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            if (result.getNumTestTotal() == 0) {
                throw new AbortException("Result does not have test");
            }
            action = new SeleniumhqBuildAction(build, result, listener);
            List files = result.getFiles();
            if (files.size() == 1) {
                FilePath source = new FilePath(build.getWorkspace(), (String)files.get(0));
                source.copyTo(new FilePath(rootTarget, "index.html"));
            } else {
                String header = "<html><head><title>Selenium result</title></head><body><center><br/><h2>Selenium Test Result</h2><ul>";
                String footer = "</ul></center></body></html>";
                OutputStream output = rootTarget.child("index.html").write();
                output.write(header.getBytes());
                int index = 0;
                for (String file : files) {
                    FilePath source = new FilePath(build.getWorkspace(), file);
                    String dest = index + "/" + source.getName();
                    source.copyTo(new FilePath(rootTarget, dest));
                    String link = "<li><a href=\"" + dest + "\">" + source.getName() + "</a></li>";
                    output.write(link.getBytes());
                    ++index;
                }
                output.write(footer.getBytes());
                output.close();
            }
        }
        catch (IOException e) {
            listener.error("Failed to archive Selenium reports");
            listener.error(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        catch (AbortException e) {
            if (build.getResult() != Result.FAILURE) {
                listener.error(e.getMessage());
                build.setResult(Result.FAILURE);
            }
            return true;
        }
        build.getActions().add(action);
        listener.getLogger().println("  Test failures: " + action.getResult().getNumTestFailures());
        listener.getLogger().println("  Test totals  : " + action.getResult().getNumTestTotal());
        listener.getLogger().println("------------------------");
        listener.getLogger().println("  Command Passes   : " + action.getResult().numCommandPasses());
        listener.getLogger().println("  Command Failures : " + action.getResult().numCommandFailures());
        listener.getLogger().println("  Command Errors   : " + action.getResult().numCommandErrors());
        if (this.useTestCommands) {
            if (action.getResult().numCommandFailures() > 0) {
                build.setResult(Result.UNSTABLE);
            }
            if (action.getResult().numCommandErrors() > 0) {
                build.setResult(Result.FAILURE);
            }
        } else if (action.getResult().getNumTestFailures() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    static /* synthetic */ String access$000(SeleniumhqPublisher x0) {
        return x0.testResults;
    }
}

