/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.seleniumhq.FileUtil;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumhqBuilder
extends Builder {
    private final String browser;
    private final String startURL;
    private final String suiteFile;
    private final String resultFile;
    private final String other;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public SeleniumhqBuilder(String browser, String startURL, String suiteFile, String resultFile, String other) {
        this.browser = browser;
        this.startURL = startURL;
        this.suiteFile = suiteFile;
        this.resultFile = resultFile;
        this.other = other;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getStartURL() {
        return this.startURL;
    }

    public String getSuiteFile() {
        return this.suiteFile;
    }

    public String getOther() {
        return this.other;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public boolean isURLSuiteFile() {
        try {
            URL url = new URL(this.suiteFile);
            return url != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFileSuiteFile(AbstractBuild<?, ?> build, Launcher launcher) throws IOException, InterruptedException {
        FilePath suiteFilePath = new FilePath(build.getWorkspace(), this.suiteFile);
        if (suiteFilePath.exists()) {
            return !suiteFilePath.isDirectory();
        }
        suiteFilePath = new FilePath(launcher.getChannel(), this.suiteFile);
        if (suiteFilePath.exists()) {
            return !suiteFilePath.isDirectory();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        if (!DESCRIPTOR.isGoodSeleniumRunner()) {
            listener.error("Please configure the Selenium Remote Control htmlSuite Runner in admin of hudson");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getBrowser() == null || this.getBrowser().length() == 0) {
            listener.error("Build config : browser field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getStartURL() == null || this.getStartURL().length() == 0) {
            listener.error("Build config : startURL field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getSuiteFile() == null || this.getSuiteFile().length() == 0) {
            listener.error("Build config : suiteFile field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (this.getResultFile() == null || this.getResultFile().length() == 0) {
            listener.error("Build config : resultFile field is mandatory");
            build.setResult(Result.FAILURE);
            return false;
        }
        String suiteFile = null;
        FilePath tempSuite = null;
        if (this.isFileSuiteFile(build, launcher)) {
            FilePath suiteFilePath = new FilePath(build.getWorkspace(), this.suiteFile);
            if (!suiteFilePath.exists()) {
                suiteFilePath = new FilePath(launcher.getChannel(), this.suiteFile);
            }
            suiteFile = suiteFilePath.getRemote();
        } else if (this.isURLSuiteFile()) {
            tempSuite = build.getWorkspace().createTempFile("tempHtmlSuite", "html");
            suiteFile = tempSuite.getRemote();
            try {
                File localWorkspace = new File(build.getRootDir(), "workspace");
                File tempSuiteLocal = File.createTempFile("tempHtmlSuite", "html");
                listener.getLogger().println("Try downloading suite file on master");
                listener.getLogger().println("    from url : " + this.suiteFile);
                listener.getLogger().println("    to file  : " + tempSuiteLocal.getPath());
                FileUtils.copyURLToFile((URL)new URL(this.suiteFile), (File)tempSuiteLocal);
                listener.getLogger().println("    ...");
                listener.getLogger().println("    Succeed");
                listener.getLogger().println("Try transfer suite file on slave");
                listener.getLogger().println("    from file : " + tempSuiteLocal.getPath());
                listener.getLogger().println("    to file   : " + suiteFile);
                FilePath sourceFile = new FilePath(tempSuiteLocal);
                sourceFile.copyTo(tempSuite);
                listener.getLogger().println("    ...");
                listener.getLogger().println("    Succeed");
                sourceFile.delete();
            }
            catch (Exception e) {
                listener.error("Downloading suite file from url failed ! Check your build configuration. ");
                build.setResult(Result.FAILURE);
                return false;
            }
        } else {
            listener.error("The suiteFile is not a file or an url ! Check your build configuration.");
            build.setResult(Result.FAILURE);
            return false;
        }
        String seleniumRunner = FileUtil.getExecutableAbsolutePath(DESCRIPTOR.getSeleniumRunner());
        FilePath resultFilePath = new FilePath(build.getWorkspace(), this.resultFile);
        resultFilePath.getParent().mkdirs();
        String resultFile = resultFilePath.getRemote();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-jar");
        cmd.add(seleniumRunner);
        cmd.addAll(this.getOthers());
        cmd.add("-htmlSuite");
        cmd.add(this.getBrowser());
        cmd.add(this.getStartURL());
        cmd.add(suiteFile);
        cmd.add(resultFile);
        try {
            String javaCmdString = "";
            Iterator itr = cmd.iterator();
            while (itr.hasNext()) {
                javaCmdString = javaCmdString + " " + (String)itr.next();
            }
            listener.getLogger().println(javaCmdString);
            launcher.launch().cmds(cmd).envs((Map)build.getEnvironment((TaskListener)listener)).stdout((OutputStream)listener.getLogger()).pwd(build.getWorkspace()).join();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.getLogger().println("IOException!");
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            listener.getLogger().println("InterruptedException!");
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempSuite != null) {
                tempSuite.delete();
            }
        }
    }

    private final ArrayList getOthers() {
        ArrayList<String> cmdParams = new ArrayList<String>();
        if (this.getOther() != null && !this.getOther().isEmpty()) {
            String otherParams = this.getOther();
            String[] otherParamsArray = otherParams.split(" ");
            for (int i = 0; i < otherParamsArray.length; ++i) {
                String paramBuffer;
                if (otherParamsArray[i].matches("\"")) {
                    paramBuffer = otherParamsArray[i];
                    do {
                        paramBuffer = paramBuffer + otherParamsArray[++i];
                    } while (!otherParamsArray[i].matches("\"") && i < otherParamsArray.length);
                    cmdParams.add(paramBuffer);
                    continue;
                }
                if (otherParamsArray[i].matches("'")) {
                    paramBuffer = otherParamsArray[i];
                    do {
                        paramBuffer = paramBuffer + otherParamsArray[++i];
                    } while (!otherParamsArray[i].matches("'") && i < otherParamsArray.length);
                    cmdParams.add(paramBuffer);
                    continue;
                }
                cmdParams.add(otherParamsArray[i]);
            }
        }
        return cmdParams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<Builder> {
        private String seleniumRunner;

        DescriptorImpl() {
            super(SeleniumhqBuilder.class);
            this.load();
        }

        public FormValidation doCheckSeleniumRunner(@QueryParameter String value) {
            return FormValidation.validateExecutable((String)value);
        }

        public String getDisplayName() {
            return "SeleniumHQ htmlSuite Run";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.seleniumRunner = o.getString("seleniumRunner");
            this.save();
            return super.configure(req, o);
        }

        public String getSeleniumRunner() {
            return this.seleniumRunner;
        }

        public void setSeleniumRunner(String seleniumRunner) {
            this.seleniumRunner = seleniumRunner;
        }

        public boolean isGoodSeleniumRunner() {
            return this.seleniumRunner != null && this.seleniumRunner.length() > 0;
        }
    }
}

