/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.seleniumhq;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.seleniumhq.AbortException;
import hudson.plugins.seleniumhq.SuiteResult;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SuiteResult> suites = new ArrayList<SuiteResult>();
    private List<String> files = new ArrayList<String>();

    public TestResult() {
    }

    public TestResult(long buildTime, DirectoryScanner results) throws IOException {
        this.parse(buildTime, results);
    }

    public int getNumTestPasses() {
        int count = 0;
        for (SuiteResult suite : this.suites) {
            count += suite.getNumTestPasses();
        }
        return count;
    }

    public int getNumTestFailures() {
        int count = 0;
        for (SuiteResult suite : this.suites) {
            count += suite.getNumTestFailures();
        }
        return count;
    }

    public int numCommandPasses() {
        int count = 0;
        for (SuiteResult suite : this.suites) {
            count += suite.numCommandPasses();
        }
        return count;
    }

    public int numCommandFailures() {
        int count = 0;
        for (SuiteResult suite : this.suites) {
            count += suite.numCommandFailures();
        }
        return count;
    }

    public int numCommandErrors() {
        int count = 0;
        for (SuiteResult suite : this.suites) {
            count += suite.numCommandErrors();
        }
        return count;
    }

    public int getNumTestTotal() {
        return this.getNumTestPasses() + this.getNumTestFailures();
    }

    public List<String> getFiles() {
        return this.files;
    }

    public void parse(long buildTime, DirectoryScanner results) throws IOException {
        String[] includedFiles = results.getIncludedFiles();
        File baseDir = results.getBasedir();
        boolean parsed = false;
        for (String value : includedFiles) {
            File reportFile = new File(baseDir, value);
            if (buildTime - 1000L > reportFile.lastModified()) continue;
            if (reportFile.length() == 0L) {
                throw new IOException("File was empty " + reportFile + "\n" + "  Is this really a Selenium report file? \n  Your configuration must be matching too many files ?");
            }
            this.parse(reportFile);
            this.files.add(new FilePath(reportFile).getRemote());
            parsed = true;
        }
        if (!parsed) {
            long localTime = System.currentTimeMillis();
            if (localTime < buildTime - 1000L) {
                throw new AbortException("Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.");
            }
            File f = new File(baseDir, includedFiles[0]);
            throw new AbortException(String.format("Test reports were found but none of them are new. Did tests run? \nFor example, %s is %s old\n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified()))));
        }
    }

    public void parse(File reportFile) throws IOException {
        try {
            this.suites.add(SuiteResult.parse(new FileInputStream(reportFile)));
        }
        catch (Exception e) {
            throw new IOException2("Failed to read " + reportFile + "\n" + "  Is this really a Selenium report file? \n  Your configuration must be matching too many files ?", (Throwable)e);
        }
    }
}

