/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.seleniumhtmlreport;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.hudson.plugins.seleniumhtmlreport.SeleniumHtmlReportAction;
import org.jvnet.hudson.plugins.seleniumhtmlreport.TestResult;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumHtmlReportPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SELENIUM_REPORTS_TARGET = "seleniumReports";
    private final String testResultsDir;

    @DataBoundConstructor
    public SeleniumHtmlReportPublisher(String testResultsDir) {
        this.testResultsDir = testResultsDir;
    }

    public String getTestResultsDir() {
        return this.testResultsDir;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Publishing Selenium report...");
        FilePath seleniumResults = build.getWorkspace().child(this.testResultsDir);
        FilePath target = SeleniumHtmlReportPublisher.getSeleniumReportsDir(build);
        this.copyReports(seleniumResults, target, listener);
        List<TestResult> results = this.createResults(build, listener);
        SeleniumHtmlReportAction action = new SeleniumHtmlReportAction(build, listener, results);
        build.getActions().add(action);
        this.calculateResultState(build, results, listener);
        return true;
    }

    private void copyReports(FilePath seleniumResults, FilePath target, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Copying the reports.");
        seleniumResults.copyRecursiveTo(target);
    }

    private List<TestResult> createResults(AbstractBuild<?, ?> build, BuildListener listener) throws IOException {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        FileSet fs = Util.createFileSet((File)new File(build.getRootDir(), SELENIUM_REPORTS_TARGET), (String)"**/*");
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] files = ds.getIncludedFiles();
        if (files.length == 0) {
            return results;
        }
        for (String selfile : files) {
            results.add(TestResult.parse(build, listener, selfile));
        }
        return results;
    }

    private void calculateResultState(AbstractBuild<?, ?> build, List<TestResult> results, BuildListener listener) {
        if (Result.ABORTED == build.getResult() || Result.FAILURE == build.getResult()) {
            return;
        }
        for (TestResult result : results) {
            if (result.getNumCommandFailures() > 0) {
                listener.getLogger().println("Set result to UNSTABLE");
                build.setResult(Result.UNSTABLE);
            }
            if (result.getNumCommandErrors() <= 0) continue;
            listener.getLogger().println("Set result to FAILURE");
            build.setResult(Result.FAILURE);
            break;
        }
    }

    protected static FilePath getSeleniumReportsDir(AbstractBuild<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), SELENIUM_REPORTS_TARGET));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(SeleniumHtmlReportPublisher.class);
        }

        public String getDisplayName() {
            return "Publish Selenium Html Report";
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

