/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.seleniumhtmlreport;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.hudson.plugins.seleniumhtmlreport.SeleniumHtmlReportAction;
import org.jvnet.hudson.plugins.seleniumhtmlreport.TestResult;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SeleniumHtmlReportPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SELENIUM_REPORTS_TARGET = "seleniumReports";
    private final String testResultsDir;

    @DataBoundConstructor
    public SeleniumHtmlReportPublisher(String testResultsDir) {
        this.testResultsDir = testResultsDir;
    }

    public String getTestResultsDir() {
        return this.testResultsDir;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("Publishing Selenium report...");
        FilePath seleniumResults = build.getWorkspace().child(this.testResultsDir);
        FilePath target = SeleniumHtmlReportPublisher.getSeleniumReportsDir(build);
        this.copyReports(seleniumResults, target, listener);
        List results = this.createResults(build, listener);
        SeleniumHtmlReportAction action = new SeleniumHtmlReportAction(build, listener, results);
        build.getActions().add(action);
        this.calculateResultState(build, results, listener);
        return true;
    }

    private void copyReports(FilePath seleniumResults, FilePath target, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Copying the reports.");
        seleniumResults.copyRecursiveTo(target);
    }

    private List<TestResult> createResults(AbstractBuild<?, ?> build, BuildListener listener) throws IOException {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        FileSet fs = Util.createFileSet((File)new File(build.getRootDir(), "seleniumReports"), (String)"**/*");
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] files = ds.getIncludedFiles();
        if (files.length == 0) {
            return results;
        }
        for (String selfile : files) {
            results.add(TestResult.parse(build, (BuildListener)listener, (String)selfile));
        }
        return results;
    }

    private void calculateResultState(AbstractBuild<?, ?> build, List<TestResult> results, BuildListener listener) {
        if (Result.ABORTED == build.getResult() || Result.FAILURE == build.getResult()) {
            return;
        }
        for (TestResult result : results) {
            if (result.getNumCommandFailures() > 0) {
                listener.getLogger().println("Set result to UNSTABLE");
                build.setResult(Result.UNSTABLE);
            }
            if (result.getNumCommandErrors() <= 0) continue;
            listener.getLogger().println("Set result to FAILURE");
            build.setResult(Result.FAILURE);
            break;
        }
    }

    protected static FilePath getSeleniumReportsDir(AbstractBuild<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), "seleniumReports"));
    }
}

