/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.seleniumhtmlreport;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jvnet.hudson.plugins.seleniumhtmlreport.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TestResult
implements Serializable {
    private final String resultFileName;
    private String result = "";
    private int totalTime = 0;
    private int numTestPasses = 0;
    private int numTestFailures = 0;
    private int numCommandPasses = 0;
    private int numCommandFailures = 0;
    private int numCommandErrors = 0;

    private TestResult(String resultFileName) {
        this.resultFileName = resultFileName;
    }

    public int getNumTestPasses() {
        return this.numTestPasses;
    }

    public int getNumTestFailures() {
        return this.numTestFailures;
    }

    public int getNumCommandPasses() {
        return this.numCommandPasses;
    }

    public int getNumCommandFailures() {
        return this.numCommandFailures;
    }

    public int getNumCommandErrors() {
        return this.numCommandErrors;
    }

    public int getNumTestTotal() {
        return this.getNumTestPasses() + this.getNumTestFailures();
    }

    public String getResult() {
        return this.result;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public String getResultFileName() {
        return this.resultFileName;
    }

    public static TestResult parse(AbstractBuild<?, ?> build, BuildListener listener, String resultFileName) throws IOException {
        TestResult result = new TestResult(resultFileName);
        listener.getLogger().println("parsing resultFile " + result.getResultFileName());
        File reportFile = TestResult.getReportFileFor(build, (TestResult)result);
        InfoParser parser = new InfoParser(reportFile);
        result.result = parser.getString("result:");
        result.totalTime = parser.getInt("totalTime:");
        result.numTestPasses = parser.getInt("numTestPasses:");
        result.numTestFailures = parser.getInt("numTestFailures:");
        result.numCommandPasses = parser.getInt("numCommandPasses:");
        result.numCommandFailures = parser.getInt("numCommandFailures:");
        result.numCommandErrors = parser.getInt("numCommandErrors:");
        return result;
    }

    protected static File getReportFileFor(AbstractBuild<?, ?> build, TestResult testResult) {
        return new File(build.getRootDir(), "seleniumReports/" + testResult.getResultFileName());
    }
}

